/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.util.ui;

import hirondelle.stocks.preferences.GeneralLookPreferencesEditor;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Consts;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class UiUtil {
    private static final String BACK_SLASH = "/";

    public static void centerAndShow(Window window) {
        window.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        int n = dimension.width / 2 - dimension2.width / 2;
        int n2 = dimension.height / 2 - dimension2.height / 2;
        window.setLocation(n, n2);
        window.setVisible(true);
    }

    public static void centerOnParentAndShow(Window window) {
        int n;
        window.pack();
        Dimension dimension = window.getParent().getSize();
        Dimension dimension2 = window.getSize();
        int n2 = window.getParent().getLocationOnScreen().x + (dimension.width / 2 - dimension2.width / 2);
        int n3 = window.getParent().getLocationOnScreen().y + (dimension.height / 2 - dimension2.height / 2);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = n2 + dimension2.width - dimension3.width;
        if (n4 > 0) {
            n2 -= n4;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = n3 + dimension2.height - dimension3.height) > 0) {
            n3 -= n;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        window.setLocation(n2, n3);
        window.setVisible(true);
    }

    public static Border getStandardBorder() {
        return BorderFactory.createEmptyBorder(11, 11, 11, 11);
    }

    public static String getDialogTitle(String string) {
        Args.checkForContent(string);
        StringBuilder stringBuilder = new StringBuilder("StocksMonitor");
        stringBuilder.append(": ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static JComponent getCommandRow(List<JComponent> list) {
        UiUtil.equalizeSizes(list);
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 0);
        jPanel.setLayout(boxLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
        jPanel.add(Box.createHorizontalGlue());
        Iterator<JComponent> iterator = list.iterator();
        while (iterator.hasNext()) {
            jPanel.add(iterator.next());
            if (!iterator.hasNext()) continue;
            jPanel.add(Box.createHorizontalStrut(5));
        }
        return jPanel;
    }

    public static JComponent getCommandColumn(List<JComponent> list) {
        UiUtil.equalizeSizes(list);
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 17, 0, 0));
        Iterator<JComponent> iterator = list.iterator();
        while (iterator.hasNext()) {
            jPanel.add(iterator.next());
            if (!iterator.hasNext()) continue;
            jPanel.add(Box.createVerticalStrut(5));
        }
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    public static ImageIcon getImageIcon(String string) {
        if (!string.startsWith(BACK_SLASH)) {
            throw new IllegalArgumentException("Image identifier does not start with backslash: " + string);
        }
        return UiUtil.fetchImageIcon(string, UiUtil.class);
    }

    public static ImageIcon getImageIcon(String string, Class<?> clazz) {
        if (string.startsWith(BACK_SLASH)) {
            throw new IllegalArgumentException("Image identifier starts with a backslash: " + string);
        }
        return UiUtil.fetchImageIcon(string, clazz);
    }

    public static Icon getEmptyIcon() {
        GeneralLookPreferencesEditor generalLookPreferencesEditor = new GeneralLookPreferencesEditor();
        return generalLookPreferencesEditor.hasLargeIcons() ? EmptyIcon.SIZE_24 : EmptyIcon.SIZE_16;
    }

    public static final Dimension getDimensionFromPercent(int n, int n2) {
        int n3 = 1;
        int n4 = 100;
        Args.checkForRange(n, n3, n4);
        Args.checkForRange(n2, n3, n4);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return UiUtil.calcDimensionFromPercent(dimension, n, n2);
    }

    public static void equalizeSizes(List<JComponent> list) {
        Dimension dimension = new Dimension(0, 0);
        for (JComponent jComponent : list) {
            Dimension dimension2 = jComponent.getPreferredSize();
            double d = Math.max(dimension.getWidth(), dimension2.getWidth());
            double d2 = Math.max(dimension.getHeight(), dimension2.getHeight());
            dimension.setSize(d, d2);
        }
        UiUtil.setSizes(list, dimension);
    }

    public static JTextField addSimpleEntryField(Container container, String string, String string2, int n, GridBagConstraints gridBagConstraints, String string3) {
        Args.checkForNull(string);
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonic(n);
        container.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = new JTextField(20);
        jLabel.setLabelFor(jTextField);
        jTextField.setToolTipText(string3);
        if (string2 != null) {
            jTextField.setText(string2);
        }
        gridBagConstraints.gridx = ++gridBagConstraints.gridx;
        if (gridBagConstraints.weightx == 0.0) {
            gridBagConstraints.weightx = 1.0;
        }
        container.add((Component)jTextField, gridBagConstraints);
        return jTextField;
    }

    public static GridBagConstraints getConstraints(int n, int n2) {
        int n3 = 0;
        int n4 = 10;
        Args.checkForRange(n, n3, n4);
        Args.checkForRange(n2, n3, n4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        return gridBagConstraints;
    }

    public static GridBagConstraints getConstraints(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 10;
        Args.checkForRange(n4, n5, n6);
        Args.checkForRange(n3, n5, n6);
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(n, n2);
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.gridwidth = n3;
        return gridBagConstraints;
    }

    public static JLabel addSimpleDisplayField(Container container, String string, Object object, GridBagConstraints gridBagConstraints, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(": ");
        JLabel jLabel = new JLabel(stringBuilder.toString());
        container.add((Component)jLabel, gridBagConstraints);
        String string2 = object != null ? object.toString() : "";
        JLabel jLabel2 = new JLabel(string2);
        UiUtil.truncateLabelIfLong(jLabel2);
        gridBagConstraints.gridx = ++gridBagConstraints.gridx;
        if (bl) {
            gridBagConstraints.weightx = 1.0;
        }
        container.add((Component)jLabel2, gridBagConstraints);
        return jLabel2;
    }

    public static void addSimpleDisplayFields(Container container, Map<String, String> map) {
        Set<String> set = map.keySet();
        int n = 0;
        for (String string : set) {
            String string2 = map.get(string);
            if (string2 == null) {
                string2 = "";
            }
            UiUtil.addSimpleDisplayField(container, string, string2, UiUtil.getConstraints(n, 0), true);
            ++n;
        }
    }

    public static void addVerticalGridGlue(JPanel jPanel, int n) {
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(n, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)new JLabel(), gridBagConstraints);
    }

    public static String getLocalizedPercent(Number number) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(2);
        return numberFormat.format(number.doubleValue());
    }

    public static String getLocalizedInteger(Number number) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        return numberFormat.format(number.intValue());
    }

    public static String getLocalizedTime(Date date) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        return dateFormat.format(date);
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static JTextArea getStandardTextArea(String string) {
        Args.checkForContent(string);
        if (string.indexOf(Consts.NEW_LINE) != -1) {
            throw new IllegalArgumentException("Must not contain new line characters: " + string);
        }
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setMargin(new Insets(0, 5, 0, 5));
        jTextArea.setBackground(MetalLookAndFeel.getMenuBackground());
        return jTextArea;
    }

    public static JTextArea getStandardTextAreaHardNewLines(String string) {
        Args.checkForContent(string);
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 5, 0, 5));
        jTextArea.setBackground(MetalLookAndFeel.getMenuBackground());
        return jTextArea;
    }

    public static void alignAllX(Container container, AlignX alignX) {
        List<Component> list = Arrays.asList(container.getComponents());
        for (Component component : list) {
            JComponent jComponent = (JComponent)component;
            jComponent.setAlignmentX(alignX.getValue());
        }
    }

    public static void alignAllY(Container container, AlignY alignY) {
        List<Component> list = Arrays.asList(container.getComponents());
        for (JComponent jComponent : list) {
            jComponent.setAlignmentY(alignY.getValue());
        }
    }

    public static void noDefaultButton(JRootPane jRootPane) {
        jRootPane.setDefaultButton(null);
    }

    private static String addSizeToStandardIcon(String string) {
        assert (Util.textHasContent(string));
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string.startsWith("/toolbar")) {
            GeneralLookPreferencesEditor generalLookPreferencesEditor = new GeneralLookPreferencesEditor();
            if (generalLookPreferencesEditor.hasLargeIcons()) {
                stringBuilder.append("24.gif");
            } else {
                stringBuilder.append("16.gif");
            }
        }
        return stringBuilder.toString();
    }

    private static void setSizes(List list, Dimension dimension) {
        for (JComponent jComponent : list) {
            jComponent.setPreferredSize((Dimension)dimension.clone());
            jComponent.setMaximumSize((Dimension)dimension.clone());
        }
    }

    private static Dimension calcDimensionFromPercent(Dimension dimension, int n, int n2) {
        int n3 = dimension.width * n / 100;
        int n4 = dimension.height * n2 / 100;
        return new Dimension(n3, n4);
    }

    private static void truncateLabelIfLong(JLabel jLabel) {
        String string = jLabel.getText();
        if (string.length() > 35) {
            jLabel.setToolTipText(string);
            String string2 = string.substring(0, 35) + "...";
            jLabel.setText(string2);
        }
    }

    private static ImageIcon fetchImageIcon(String string, Class<?> clazz) {
        String string2 = UiUtil.addSizeToStandardIcon(string);
        URL uRL = clazz.getResource(string2);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        throw new IllegalArgumentException("Cannot retrieve image using id: " + string);
    }

    public static enum AlignY {
        TOP(0.0f),
        CENTER(0.5f),
        BOTTOM(1.0f);

        private final float fValue;

        float getValue() {
            return this.fValue;
        }

        private AlignY(float f) {
            this.fValue = f;
        }
    }

    public static enum AlignX {
        LEFT(0.0f),
        CENTER(0.5f),
        RIGHT(1.0f);

        private final float fValue;

        public float getValue() {
            return this.fValue;
        }

        private AlignX(float f) {
            this.fValue = f;
        }
    }
}

