/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.util.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.metal.MetalTheme;

public final class Theme {
    public static final MetalTheme DEFAULT = new Default();
    public static final MetalTheme AQUA = new Aqua();
    public static final MetalTheme LARGE_FONT = new LargeFont();
    public static final MetalTheme LOW_VISION = new LowVision();
    private static final MetalTheme[] fValues = new MetalTheme[]{DEFAULT, AQUA, LARGE_FONT, LOW_VISION};
    public static final List<MetalTheme> VALUES = Collections.unmodifiableList(Arrays.asList(fValues));
    private static final String fDEFAULT_NAME = "Default";
    private static final String fAQUA_NAME = "Aqua";
    private static final String fLARGE_FONT_NAME = "Large Font";
    private static final String fLOW_VISION_NAME = "Low Vision";

    public static MetalTheme valueOf(String string) {
        if (string == null) {
            return null;
        }
        for (MetalTheme metalTheme : VALUES) {
            if (!string.endsWith(metalTheme.getName())) continue;
            return metalTheme;
        }
        throw new IllegalArgumentException("Cannot parse into Theme object:" + string);
    }

    public static boolean hasLargeFont(MetalTheme metalTheme) {
        return metalTheme == LARGE_FONT || metalTheme == LOW_VISION;
    }

    private static class LowVision
    extends LargeFont {
        private static final String fName = "Low Vision";
        private final ColorUIResource fPrimary1 = new ColorUIResource(0, 0, 0);
        private final ColorUIResource fPrimary2 = new ColorUIResource(204, 204, 204);
        private final ColorUIResource fPrimary3 = new ColorUIResource(255, 255, 255);
        private final ColorUIResource fPrimaryHighlight = new ColorUIResource(102, 102, 102);
        private final ColorUIResource fSecondary2 = new ColorUIResource(204, 204, 204);
        private final ColorUIResource fSecondary3 = new ColorUIResource(255, 255, 255);
        private final Border fBlackLineBorder = new BorderUIResource(new LineBorder(this.getBlack()));
        private final Object fTextBorder = new BorderUIResource(new CompoundBorder(this.fBlackLineBorder, new BasicBorders.MarginBorder()));
        private final int fInternalFrameIconSize = 30;
        private final Integer fScrollBarWidth = new Integer(25);

        private LowVision() {
        }

        @Override
        public String getName() {
            return "Low Vision";
        }

        @Override
        public ColorUIResource getPrimaryControlHighlight() {
            return this.fPrimaryHighlight;
        }

        @Override
        public ColorUIResource getControlHighlight() {
            return super.getSecondary3();
        }

        @Override
        public ColorUIResource getFocusColor() {
            return this.getBlack();
        }

        @Override
        public ColorUIResource getTextHighlightColor() {
            return this.getBlack();
        }

        @Override
        public ColorUIResource getHighlightedTextColor() {
            return this.getWhite();
        }

        @Override
        public ColorUIResource getMenuSelectedBackground() {
            return this.getBlack();
        }

        @Override
        public ColorUIResource getMenuSelectedForeground() {
            return this.getWhite();
        }

        @Override
        public ColorUIResource getAcceleratorForeground() {
            return this.getBlack();
        }

        @Override
        public ColorUIResource getAcceleratorSelectedForeground() {
            return this.getWhite();
        }

        @Override
        public void addCustomEntriesToTable(UIDefaults uIDefaults) {
            super.addCustomEntriesToTable(uIDefaults);
            uIDefaults.put("ToolTip.border", this.fBlackLineBorder);
            uIDefaults.put("TitledBorder.border", this.fBlackLineBorder);
            uIDefaults.put("ScrollPane.border", this.fBlackLineBorder);
            uIDefaults.put("TextField.border", this.fTextBorder);
            uIDefaults.put("PasswordField.border", this.fTextBorder);
            uIDefaults.put("TextArea.border", this.fTextBorder);
            uIDefaults.put("TextPane.border", this.fTextBorder);
            uIDefaults.put("EditorPane.border", this.fTextBorder);
            uIDefaults.put("InternalFrame.closeIcon", MetalIconFactory.getInternalFrameCloseIcon(30));
            uIDefaults.put("InternalFrame.maximizeIcon", MetalIconFactory.getInternalFrameMaximizeIcon(30));
            uIDefaults.put("InternalFrame.iconifyIcon", MetalIconFactory.getInternalFrameMinimizeIcon(30));
            uIDefaults.put("InternalFrame.minimizeIcon", MetalIconFactory.getInternalFrameAltMaximizeIcon(30));
            uIDefaults.put("ScrollBar.width", this.fScrollBarWidth);
        }

        @Override
        protected ColorUIResource getPrimary1() {
            return this.fPrimary1;
        }

        @Override
        protected ColorUIResource getPrimary2() {
            return this.fPrimary2;
        }

        @Override
        protected ColorUIResource getPrimary3() {
            return this.fPrimary3;
        }

        @Override
        protected ColorUIResource getSecondary2() {
            return this.fSecondary2;
        }

        @Override
        protected ColorUIResource getSecondary3() {
            return this.fSecondary3;
        }
    }

    private static class LargeFont
    extends Default {
        private final String fName = "Large Font";
        private final FontUIResource fControlFont = new FontUIResource("Dialog", 1, 18);
        private final FontUIResource fSystemFont = new FontUIResource("Dialog", 0, 18);
        private final FontUIResource fWindowTitleFont = new FontUIResource("Dialog", 1, 18);
        private final FontUIResource fUserFont = new FontUIResource("SansSerif", 0, 18);
        private final FontUIResource fSmallFont = new FontUIResource("Dialog", 0, 14);

        private LargeFont() {
        }

        @Override
        public String getName() {
            return Theme.fLARGE_FONT_NAME;
        }

        @Override
        public FontUIResource getControlTextFont() {
            return this.fControlFont;
        }

        @Override
        public FontUIResource getSystemTextFont() {
            return this.fSystemFont;
        }

        @Override
        public FontUIResource getUserTextFont() {
            return this.fUserFont;
        }

        @Override
        public FontUIResource getMenuTextFont() {
            return this.fControlFont;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.fWindowTitleFont;
        }

        @Override
        public FontUIResource getSubTextFont() {
            return this.fSmallFont;
        }
    }

    private static class Aqua
    extends Default {
        private final String fName = "Aqua";
        private final ColorUIResource fPrimary1 = new ColorUIResource(102, 153, 153);
        private final ColorUIResource fPrimary2 = new ColorUIResource(128, 192, 192);
        private final ColorUIResource fPrimary3 = new ColorUIResource(159, 235, 235);

        private Aqua() {
        }

        @Override
        public String getName() {
            return Theme.fAQUA_NAME;
        }

        @Override
        protected ColorUIResource getPrimary1() {
            return this.fPrimary1;
        }

        @Override
        protected ColorUIResource getPrimary2() {
            return this.fPrimary2;
        }

        @Override
        protected ColorUIResource getPrimary3() {
            return this.fPrimary3;
        }
    }

    private static class Default
    extends DefaultMetalTheme {
        private final String fName = "Default";

        private Default() {
        }

        @Override
        public String getName() {
            return Theme.fDEFAULT_NAME;
        }

        public final String toString() {
            return this.getName();
        }
    }
}

