/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.util.ui;

import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class StandardEditor {
    private final String fTitle;
    private final JFrame fParent;
    private JDialog fDialog;
    private final int fCloseAction;

    protected StandardEditor(String string, JFrame jFrame, CloseAction closeAction) {
        Args.checkForContent(string);
        Args.checkForNull(jFrame);
        this.fTitle = string;
        this.fParent = jFrame;
        this.fCloseAction = closeAction.getValue();
    }

    public final void showDialog() {
        boolean bl = true;
        this.fDialog = new JDialog(this.fParent, UiUtil.getDialogTitle(this.fTitle), bl);
        this.fDialog.setDefaultCloseOperation(this.fCloseAction);
        this.fDialog.setResizable(false);
        this.addCancelByEscapeKey();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(UiUtil.getStandardBorder());
        jPanel.add(this.getEditorUI());
        jPanel.add(this.getCommandRow());
        this.fDialog.getContentPane().add(jPanel);
        UiUtil.centerOnParentAndShow(this.fDialog);
    }

    public final void dispose() {
        this.fDialog.dispose();
    }

    protected abstract JComponent getEditorUI();

    protected abstract void okAction();

    private JComponent getCommandRow() {
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StandardEditor.this.okAction();
            }
        });
        this.fDialog.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StandardEditor.this.closeDialog();
            }
        });
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(jButton);
        arrayList.add(jButton2);
        return UiUtil.getCommandRow(arrayList);
    }

    private void addCancelByEscapeKey() {
        String string = "CANCEL_ACTION_KEY";
        int n = 0;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, n, false);
        InputMap inputMap = this.fDialog.getRootPane().getInputMap(1);
        inputMap.put(keyStroke, string);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StandardEditor.this.closeDialog();
            }
        };
        this.fDialog.getRootPane().getActionMap().put(string, abstractAction);
    }

    private void closeDialog() {
        this.fDialog.dispose();
    }

    protected static enum CloseAction {
        DISPOSE(2),
        HIDE(1);

        private final int fAction;

        int getValue() {
            return this.fAction;
        }

        private CloseAction(int n2) {
            this.fAction = n2;
        }
    }
}

