/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.util;

public final class HashCodeUtil {
    public static final int SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    public static int hash(int n, boolean bl) {
        return HashCodeUtil.firstTerm(n) + (bl ? 1 : 0);
    }

    public static int hash(int n, char c) {
        return HashCodeUtil.firstTerm(n) + c;
    }

    public static int hash(int n, int n2) {
        return HashCodeUtil.firstTerm(n) + n2;
    }

    public static int hash(int n, long l) {
        return HashCodeUtil.firstTerm(n) + (int)(l ^ l >>> 32);
    }

    public static int hash(int n, float f) {
        return HashCodeUtil.hash(n, Float.floatToIntBits(f));
    }

    public static int hash(int n, double d) {
        return HashCodeUtil.hash(n, Double.doubleToLongBits(d));
    }

    public static int hash(int n, Object object) {
        return HashCodeUtil.hash(n, object == null ? 0 : object.hashCode());
    }

    public static int hash(int n, Object[] objectArray) {
        int n2 = n;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, objectArray[i]);
        }
        return n2;
    }

    public static int hash(int n, boolean[] blArray) {
        int n2 = n;
        for (int i = 0; i < blArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, blArray[i]);
        }
        return n2;
    }

    public static int hash(int n, char[] cArray) {
        int n2 = n;
        for (int i = 0; i < cArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, cArray[i]);
        }
        return n2;
    }

    public static int hash(int n, byte[] byArray) {
        int n2 = n;
        for (int i = 0; i < byArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, byArray[i]);
        }
        return n2;
    }

    public static int hash(int n, short[] sArray) {
        int n2 = n;
        for (int i = 0; i < sArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, sArray[i]);
        }
        return n2;
    }

    public static int hash(int n, int[] nArray) {
        int n2 = n;
        for (int i = 0; i < nArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, nArray[i]);
        }
        return n2;
    }

    public static int hash(int n, long[] lArray) {
        int n2 = n;
        for (int i = 0; i < lArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, lArray[i]);
        }
        return n2;
    }

    public static int hash(int n, float[] fArray) {
        int n2 = n;
        for (int i = 0; i < fArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, fArray[i]);
        }
        return n2;
    }

    public static int hash(int n, double[] dArray) {
        int n2 = n;
        for (int i = 0; i < dArray.length; ++i) {
            n2 = HashCodeUtil.hash(n2, dArray[i]);
        }
        return n2;
    }

    private static int firstTerm(int n) {
        return 37 * n;
    }
}

