/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.table;

import hirondelle.stocks.table.SortBy;
import hirondelle.stocks.table.SortOrder;
import hirondelle.stocks.util.Args;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

final class TableSortIndicator
extends Observable {
    private final JTable fTable;
    private final Icon fUpIcon;
    private final Icon fDownIcon;
    private SortBy fCurrentSort;
    private SortBy fTargetSort;
    private static final SortOrder fDEFAULT_SORT_ORDER = SortOrder.DESCENDING;

    TableSortIndicator(JTable jTable, Icon icon, Icon icon2) {
        Args.checkForNull(icon);
        Args.checkForNull(icon2);
        this.fTable = jTable;
        this.fUpIcon = icon;
        this.fDownIcon = icon2;
        this.fCurrentSort = SortBy.NONE;
        this.initHeaderClickListener();
        this.initHeaderRenderers();
        assert (this.getRenderer(0) != null) : "Ctor - renderer 0 is null.";
    }

    SortBy getSortBy() {
        return this.fCurrentSort;
    }

    void setSortBy(SortBy sortBy) {
        this.validateIdx(sortBy.getColumn());
        this.initHeaderRenderers();
        assert (this.getRenderer(0) != null) : "setSortBy - renderer 0 is null.";
        this.fTargetSort = sortBy;
        if (this.fCurrentSort == SortBy.NONE) {
            this.setInitialHeader();
        } else if (this.fCurrentSort.getColumn() == this.fTargetSort.getColumn() && this.fCurrentSort.getOrder() != this.fTargetSort.getOrder()) {
            this.toggleIcon();
        } else {
            this.updateTwoHeaders();
        }
        this.synchCurrentSortWithSelectedSort();
        this.notifyAndPaint();
    }

    private boolean isValidColumnIdx(int n) {
        return 0 <= n && n <= this.fTable.getColumnCount() - 1;
    }

    private void validateIdx(int n) {
        if (!this.isValidColumnIdx(n)) {
            throw new IllegalArgumentException("Column index is out of range: " + n);
        }
    }

    private void initHeaderRenderers() {
        for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
            TableColumn tableColumn = this.fTable.getColumnModel().getColumn(i);
            tableColumn.setHeaderRenderer(new Renderer(this.fTable.getTableHeader()));
            assert (tableColumn.getHeaderRenderer() != null) : "Header Renderer is null";
        }
    }

    private Renderer getRenderer(int n) {
        TableColumn tableColumn = this.fTable.getColumnModel().getColumn(n);
        return (Renderer)tableColumn.getHeaderRenderer();
    }

    private void initHeaderClickListener() {
        this.fTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = TableSortIndicator.this.fTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                TableSortIndicator.this.processClick(n);
            }
        });
    }

    private void processClick(int n) {
        this.validateIdx(n);
        this.fTargetSort = this.fCurrentSort.getColumn() == n ? new SortBy(this.fCurrentSort.getOrder().toggle(), n) : new SortBy(fDEFAULT_SORT_ORDER, n);
        if (this.fCurrentSort == SortBy.NONE) {
            this.setInitialHeader();
        }
        if (this.fCurrentSort.getColumn() == this.fTargetSort.getColumn()) {
            this.toggleIcon();
        } else {
            this.updateTwoHeaders();
        }
        this.synchCurrentSortWithSelectedSort();
        this.notifyAndPaint();
    }

    private void notifyAndPaint() {
        this.setChanged();
        this.notifyObservers();
        this.fTable.getTableHeader().resizeAndRepaint();
    }

    private void setInitialHeader() {
        if (this.fTargetSort.getOrder() == SortOrder.DESCENDING) {
            this.getRenderer(this.fTargetSort.getColumn()).setIcon(this.fDownIcon);
        } else {
            this.getRenderer(this.fTargetSort.getColumn()).setIcon(this.fUpIcon);
        }
    }

    private void toggleIcon() {
        Renderer renderer = this.getRenderer(this.fCurrentSort.getColumn());
        if (this.fCurrentSort.getOrder() == SortOrder.ASCENDING) {
            renderer.setIcon(this.fDownIcon);
        } else {
            renderer.setIcon(this.fUpIcon);
        }
    }

    private void updateTwoHeaders() {
        this.getRenderer(this.fCurrentSort.getColumn()).setIcon(null);
        this.getRenderer(this.fTargetSort.getColumn()).setIcon(this.fDownIcon);
    }

    private void synchCurrentSortWithSelectedSort() {
        this.fCurrentSort = this.fTargetSort;
    }

    private final class Renderer
    extends DefaultTableCellRenderer {
        private JTableHeader fTableHeader;

        Renderer(JTableHeader jTableHeader) {
            this.setHorizontalAlignment(0);
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.fTableHeader = jTableHeader;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object == null ? "" : object.toString());
            this.setFont(this.fTableHeader.getFont());
            return this;
        }
    }
}

