/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.table;

import hirondelle.stocks.table.SortOrder;
import hirondelle.stocks.util.EqualsUtil;
import hirondelle.stocks.util.HashCodeUtil;

public final class SortBy {
    public static final SortBy NONE = new SortBy();
    public static final int NO_SELECTED_COLUMN = -1;
    private final SortOrder fSortOrder;
    private final int fColumn;

    public SortBy(SortOrder sortOrder, int n) {
        this.fSortOrder = sortOrder;
        this.fColumn = n;
        this.validateState();
    }

    public SortOrder getOrder() {
        return this.fSortOrder;
    }

    public int getColumn() {
        return this.fColumn;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" {");
        stringBuilder.append(string);
        stringBuilder.append(" fSortOrder = ").append((Object)this.fSortOrder).append(string);
        stringBuilder.append(" fColumn = ").append(this.fColumn).append(string);
        stringBuilder.append("}");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SortBy)) {
            return false;
        }
        SortBy sortBy = (SortBy)object;
        return EqualsUtil.areEqual((Object)this.fSortOrder, (Object)sortBy.fSortOrder) && EqualsUtil.areEqual(this.fColumn, sortBy.fColumn);
    }

    public int hashCode() {
        int n = 23;
        n = HashCodeUtil.hash(n, (Object)this.fSortOrder);
        n = HashCodeUtil.hash(n, this.fColumn);
        return n;
    }

    private void validateState() {
        boolean bl;
        boolean bl2 = bl = this.fSortOrder != null && this.fColumn >= 0;
        if (!bl) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    private SortBy() {
        this.fSortOrder = SortOrder.DESCENDING;
        this.fColumn = -1;
    }
}

