/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.table;

import hirondelle.stocks.preferences.QuoteTablePreferencesEditor;
import hirondelle.stocks.quotes.Quote;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.table.QuoteField;
import hirondelle.stocks.table.QuoteFilterFactory;
import hirondelle.stocks.table.QuoteSorterFactory;
import hirondelle.stocks.table.RenderPrice;
import hirondelle.stocks.table.RenderRedGreen;
import hirondelle.stocks.table.RenderStockName;
import hirondelle.stocks.table.SortBy;
import hirondelle.stocks.table.SortOrder;
import hirondelle.stocks.table.TableSortIndicator;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.ui.UiUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public final class QuoteTable
extends JScrollPane
implements PropertyChangeListener,
Observer {
    private QuoteTablePreferencesEditor fTablePrefsEditor;
    private QuoteFilterFactory fQuoteFilterFactory;
    private JTable fTable;
    private QuoteTableModel fModel;
    private TableSortIndicator fTableSortIndicator;
    private static final ImageIcon UP_ICON = UiUtil.getImageIcon("/toolbarButtonGraphics/navigation/Up");
    private static final ImageIcon DOWN_ICON = UiUtil.getImageIcon("/toolbarButtonGraphics/navigation/Down");

    public QuoteTable(QuoteTablePreferencesEditor quoteTablePreferencesEditor, QuoteFilterFactory quoteFilterFactory) {
        this.fTablePrefsEditor = quoteTablePreferencesEditor;
        this.fTablePrefsEditor.addObserver(this);
        this.fQuoteFilterFactory = quoteFilterFactory;
        this.fQuoteFilterFactory.addPropertyChangeListener(this);
        this.fModel = new QuoteTableModel();
        this.fTable = new JTable(this.fModel);
        this.fTableSortIndicator = new TableSortIndicator(this.fTable, UP_ICON, DOWN_ICON);
        this.fTableSortIndicator.addObserver(this);
        this.initGui();
    }

    public void setQuoteTable(List<Quote> list) {
        this.fModel.setQuoteTable(list);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable == this.fTablePrefsEditor) {
            this.synchWithPrefs();
        } else if (observable == this.fTableSortIndicator) {
            this.fModel.filterAndSortQuotes();
        } else {
            throw new AssertionError((Object)("Unknown observable: " + observable));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fModel.filterAndSortQuotes();
    }

    private void initGui() {
        this.fTable.getTableHeader().setReorderingAllowed(false);
        this.fTable.setSelectionMode(0);
        this.synchWithPrefs();
        this.setViewportView(this.fTable);
    }

    private void synchWithPrefs() {
        this.fTable.setShowHorizontalLines(this.fTablePrefsEditor.hasHorizontalLines());
        this.fTable.setShowVerticalLines(this.fTablePrefsEditor.hasVerticalLines());
        this.fTable.setRowHeight(this.fTablePrefsEditor.getRowHeight());
        this.fModel.setColumnMapping(new ArrayList<Object>(this.fTablePrefsEditor.getColumnOrder()));
        this.synchWithTableRendererPrefs();
        int n = this.fModel.fColumnMapping.indexOf((Object)this.fTablePrefsEditor.getSortField());
        this.fTableSortIndicator.setSortBy(new SortBy(SortOrder.DESCENDING, n));
    }

    private void synchWithTableRendererPrefs() {
        for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
            String string = this.fTable.getColumnName(i);
            QuoteField quoteField = QuoteField.valueFrom(string);
            if (quoteField == QuoteField.Change || quoteField == QuoteField.PercentChange || quoteField == QuoteField.Profit || quoteField == QuoteField.PercentProfit) {
                this.fTable.getColumnModel().getColumn(i).setCellRenderer(new RenderRedGreen());
                continue;
            }
            if (quoteField == QuoteField.Price) {
                this.fTable.getColumnModel().getColumn(i).setCellRenderer(new RenderPrice());
                continue;
            }
            if (quoteField != QuoteField.Stock) continue;
            this.fTable.getColumnModel().getColumn(i).setCellRenderer(new RenderStockName());
        }
    }

    private final class QuoteTableModel
    extends AbstractTableModel {
        private List<Quote> fQuoteTable;
        private List<Quote> fFilteredSortedQuoteTable;
        private List<QuoteField> fColumnMapping;

        QuoteTableModel() {
            this.setColumnMapping(new ArrayList<Object>(QuoteTable.this.fTablePrefsEditor.getColumnOrder()));
            this.fQuoteTable = Collections.emptyList();
            this.fFilteredSortedQuoteTable = Collections.emptyList();
        }

        void setColumnMapping(List<QuoteField> list) {
            if (list == null || list.size() != QuoteField.values().length) {
                throw new IllegalArgumentException("Column mapping null or of unexpected size.");
            }
            this.fColumnMapping = Collections.unmodifiableList(list);
            this.fireTableStructureChanged();
        }

        void setQuoteTable(List<Quote> list) {
            Args.checkForNull(list);
            this.fQuoteTable = Collections.unmodifiableList(list);
            this.filterAndSortQuotes();
        }

        @Override
        public String getColumnName(int n) {
            return this.getField(n).toString();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            return object.getClass();
        }

        @Override
        public int getColumnCount() {
            return this.fColumnMapping.size();
        }

        @Override
        public int getRowCount() {
            return this.fFilteredSortedQuoteTable.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n > this.getRowCount() - 1) {
                throw new IllegalArgumentException("Row index is out of range: " + n);
            }
            if (n2 < 0 || n2 > this.getColumnCount() - 1) {
                throw new IllegalArgumentException("Column index is out of range: " + n2);
            }
            Quote quote = this.fFilteredSortedQuoteTable.get(n);
            QuoteField quoteField = this.getField(n2);
            return this.getFieldValue(quote, quoteField);
        }

        private void filterAndSortQuotes() {
            this.fFilteredSortedQuoteTable = QuoteTable.this.fQuoteFilterFactory.getSelectedFilter().sift(this.fQuoteTable);
            Collections.sort(this.fFilteredSortedQuoteTable, this.getQuoteSorter());
            if (QuoteTable.this.fTableSortIndicator.getSortBy().getOrder() == SortOrder.ASCENDING) {
                Collections.reverse(this.fFilteredSortedQuoteTable);
            }
            this.fireTableDataChanged();
        }

        private Comparator<Quote> getQuoteSorter() {
            SortBy sortBy = QuoteTable.this.fTableSortIndicator.getSortBy();
            QuoteField quoteField = QuoteTable.this.fModel.getField(sortBy.getColumn());
            return QuoteSorterFactory.getSorter(quoteField);
        }

        private QuoteField getField(int n) {
            return this.fColumnMapping.get(n);
        }

        private Object getFieldValue(Quote quote, QuoteField quoteField) {
            Comparable<Stock> comparable = null;
            if (quoteField == QuoteField.Stock) {
                comparable = quote.getStock();
            } else if (quoteField == QuoteField.Price) {
                comparable = quote.getPrice();
            } else if (quoteField == QuoteField.Change) {
                comparable = quote.getChange();
            } else if (quoteField == QuoteField.PercentChange) {
                comparable = quote.getPercentChange();
            } else if (quoteField == QuoteField.Profit) {
                comparable = quote.getProfit();
            } else if (quoteField == QuoteField.PercentProfit) {
                comparable = quote.getPercentProfit();
            } else {
                throw new AssertionError((Object)("Unknown field: " + (Object)((Object)quoteField)));
            }
            return comparable;
        }
    }
}

