/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.table;

import hirondelle.stocks.quotes.Quote;
import hirondelle.stocks.table.QuoteField;
import java.util.Comparator;

public final class QuoteSorterFactory {
    private static final Comparator<Quote> STOCK_SORTER = new StockSorter();
    private static final Comparator<Quote> PRICE_SORTER = new PriceSorter();
    private static final Comparator<Quote> CHANGE_SORTER = new ChangeSorter();
    private static final Comparator<Quote> PROFIT_SORTER = new ProfitSorter();
    private static final Comparator<Quote> PERCENT_CHANGE_SORTER = new PercentChangeSorter();
    private static final Comparator<Quote> PERCENT_PROFIT_SORTER = new PercentProfitSorter();
    private static final int BEFORE = -1;
    private static final int EQUAL = 0;
    private static final int AFTER = 1;
    private static final int REVERSE = -1;

    public static Comparator<Quote> getSorter(QuoteField quoteField) {
        Comparator<Quote> comparator = null;
        if (quoteField == QuoteField.Stock) {
            comparator = STOCK_SORTER;
        } else if (quoteField == QuoteField.Price) {
            comparator = PRICE_SORTER;
        } else if (quoteField == QuoteField.Change) {
            comparator = CHANGE_SORTER;
        } else if (quoteField == QuoteField.Profit) {
            comparator = PROFIT_SORTER;
        } else if (quoteField == QuoteField.PercentChange) {
            comparator = PERCENT_CHANGE_SORTER;
        } else if (quoteField == QuoteField.PercentProfit) {
            comparator = PERCENT_PROFIT_SORTER;
        } else {
            throw new AssertionError((Object)("Unknown quote field: " + (Object)((Object)quoteField)));
        }
        return comparator;
    }

    private QuoteSorterFactory() {
        throw new AssertionError();
    }

    private static int compareStock(Quote quote, Quote quote2) {
        return quote.getStock().compareTo(quote2.getStock());
    }

    private static int comparePrice(Quote quote, Quote quote2) {
        return -1 * quote.getPrice().compareTo(quote2.getPrice());
    }

    private static int compareChange(Quote quote, Quote quote2) {
        return -1 * quote.getChange().compareTo(quote2.getChange());
    }

    private static final class PercentChangeSorter
    extends DerivedFieldSorter {
        private PercentChangeSorter() {
        }

        @Override
        public int compareDerivedField(Quote quote, Quote quote2) {
            if (quote.getPercentChange().compareTo(quote2.getPercentChange()) <= 0) {
                return 1;
            }
            if (quote.getPercentChange().compareTo(quote2.getPercentChange()) > 0) {
                return -1;
            }
            return 0;
        }
    }

    private static final class PercentProfitSorter
    extends DerivedFieldSorter {
        private PercentProfitSorter() {
        }

        @Override
        public int compareDerivedField(Quote quote, Quote quote2) {
            if (quote.getPercentProfit().compareTo(quote2.getPercentProfit()) <= 0) {
                return 1;
            }
            if (quote.getPercentProfit().compareTo(quote2.getPercentProfit()) > 0) {
                return -1;
            }
            return 0;
        }
    }

    private static final class ProfitSorter
    extends DerivedFieldSorter {
        private ProfitSorter() {
        }

        @Override
        public int compareDerivedField(Quote quote, Quote quote2) {
            return -1 * quote.getProfit().compareTo(quote2.getProfit());
        }
    }

    private static abstract class DerivedFieldSorter
    extends QuoteSorter {
        private QuoteSorter fStockSorter = new StockSorter();

        private DerivedFieldSorter() {
        }

        @Override
        public final int compareFields(Quote quote, Quote quote2) {
            int n = this.compareDerivedField(quote, quote2);
            if (n != 0) {
                return n;
            }
            return this.fStockSorter.compareFields(quote, quote2);
        }

        abstract int compareDerivedField(Quote var1, Quote var2);
    }

    private static final class ChangeSorter
    extends QuoteSorter {
        private ChangeSorter() {
        }

        @Override
        public int compareFields(Quote quote, Quote quote2) {
            int n = QuoteSorterFactory.compareChange(quote, quote2);
            if (n != 0) {
                return n;
            }
            n = QuoteSorterFactory.compareStock(quote, quote2);
            if (n != 0) {
                return n;
            }
            return QuoteSorterFactory.comparePrice(quote, quote2);
        }
    }

    private static final class PriceSorter
    extends QuoteSorter {
        private PriceSorter() {
        }

        @Override
        public int compareFields(Quote quote, Quote quote2) {
            int n = QuoteSorterFactory.comparePrice(quote, quote2);
            if (n != 0) {
                return n;
            }
            n = QuoteSorterFactory.compareStock(quote, quote2);
            if (n != 0) {
                return n;
            }
            return QuoteSorterFactory.compareChange(quote, quote2);
        }
    }

    private static final class StockSorter
    extends QuoteSorter {
        private StockSorter() {
        }

        @Override
        public int compareFields(Quote quote, Quote quote2) {
            int n = QuoteSorterFactory.compareStock(quote, quote2);
            if (n != 0) {
                return n;
            }
            n = QuoteSorterFactory.comparePrice(quote, quote2);
            if (n != 0) {
                return n;
            }
            return QuoteSorterFactory.compareChange(quote, quote2);
        }
    }

    private static abstract class QuoteSorter
    implements Comparator<Quote> {
        private QuoteSorter() {
        }

        @Override
        public final int compare(Quote quote, Quote quote2) {
            if (quote == quote2) {
                return 0;
            }
            int n = this.compareFields(quote, quote2);
            if (n == 0) assert (quote.equals(quote2)) : "compareTo inconsistent with equals.";
            return n;
        }

        abstract int compareFields(Quote var1, Quote var2);
    }
}

