/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.table;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.quotes.Exchange;
import hirondelle.stocks.quotes.Quote;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.table.QuoteFilter;
import hirondelle.stocks.util.Util;
import java.awt.Dimension;
import java.util.LinkedHashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public final class QuoteFilterFactory
extends JScrollPane
implements Observer {
    public static final String SELECTED_FILTER = "SelectedFilter";
    private CurrentPortfolio fCurrentPortfolio;
    private DefaultTreeModel fFilterTreeModel;
    private JTree fFilterSelector;
    private QuoteFilter fSelectedFilter;
    private QuoteFilter NO_SELECTION_FILTER = new QuoteFilterAcceptAll("");
    private static final String FILTER_BY = "Filter By";
    private static final String EXCHANGE = "Exchange";
    private static final String TODAYS_CHANGE = "Today's Change";
    private static final String GAINERS = "Gainers";
    private static final String LOSERS = "Losers";
    private static final String TICKER_TYPE = "Ticker Type";
    private static final String INDEX = "Index";
    private static final String NON_INDEX = "Non-Index";
    private static final Logger fLogger = Util.getLogger(QuoteFilterFactory.class);

    public QuoteFilterFactory(CurrentPortfolio currentPortfolio) {
        this.fCurrentPortfolio = currentPortfolio;
        this.fCurrentPortfolio.addObserver(this);
        this.fSelectedFilter = this.NO_SELECTION_FILTER;
        this.initGui();
    }

    public QuoteFilter getSelectedFilter() {
        assert (this.fSelectedFilter != null) : "Filter has null value.";
        return this.fSelectedFilter;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.fSelectedFilter = this.NO_SELECTION_FILTER;
        this.synchFilterTreeWithCurrentPortfolio();
    }

    private void initGui() {
        this.initFilterTreeModel();
        this.initFilterTree();
        this.synchFilterTreeWithCurrentPortfolio();
        this.setViewportView(this.fFilterSelector);
        this.setPreferredSize(new Dimension(160, 240));
    }

    private void initFilterTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new QuoteFilterAcceptAll(EXCHANGE));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new QuoteFilterAcceptAll(TODAYS_CHANGE));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new QuoteFilterGainers()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new QuoteFilterLosers()));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new QuoteFilterAcceptAll(TICKER_TYPE));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new QuoteFilterIndex()));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new QuoteFilterNonIndex()));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new QuoteFilterAcceptAll(FILTER_BY));
        defaultMutableTreeNode4.add(defaultMutableTreeNode);
        defaultMutableTreeNode4.add(defaultMutableTreeNode2);
        defaultMutableTreeNode4.add(defaultMutableTreeNode3);
        this.fFilterTreeModel = new DefaultTreeModel(defaultMutableTreeNode4);
    }

    private void initFilterTree() {
        this.fFilterSelector = new JTree(this.fFilterTreeModel);
        this.fFilterSelector.setRootVisible(true);
        this.fFilterSelector.setShowsRootHandles(true);
        this.fFilterSelector.setEditable(false);
        this.fFilterSelector.getSelectionModel().setSelectionMode(1);
        this.fFilterSelector.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                QuoteFilterFactory.this.updateFilterAndBroadcast();
            }
        });
    }

    private void synchFilterTreeWithCurrentPortfolio() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.fFilterTreeModel.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        defaultMutableTreeNode2.removeAllChildren();
        LinkedHashSet<Exchange> linkedHashSet = new LinkedHashSet<Exchange>();
        for (Stock stock : this.fCurrentPortfolio.getStocks()) {
            Exchange exchange = stock.getExchange();
            if (linkedHashSet.contains(exchange)) continue;
            linkedHashSet.add(exchange);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new QuoteFilterExchange(exchange)));
        }
        this.fFilterTreeModel.reload();
    }

    private void updateFilterAndBroadcast() {
        if (this.hasNoSelection()) {
            return;
        }
        QuoteFilter quoteFilter = this.parseSelectedFilter();
        assert (quoteFilter != null) : "New filter is unexpectedly null.";
        assert (quoteFilter != this.NO_SELECTION_FILTER) : "New Filter is unexpected value.";
        if (this.fSelectedFilter == quoteFilter) {
            fLogger.fine("No broadcast: user selection does not have a new filter");
        } else {
            fLogger.fine("New filter being broadcast: " + quoteFilter);
            QuoteFilter quoteFilter2 = this.fSelectedFilter;
            this.fSelectedFilter = quoteFilter;
            this.firePropertyChange(SELECTED_FILTER, quoteFilter2, this.fSelectedFilter);
        }
    }

    private boolean hasNoSelection() {
        return this.getSelectedNode() == null;
    }

    private QuoteFilter parseSelectedFilter() {
        assert (this.getSelectedNode() != null) : "Selected Filter unexpectedly null.";
        return (QuoteFilter)this.getSelectedNode().getUserObject();
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.fFilterSelector.getLastSelectedPathComponent();
    }

    private static final class QuoteFilterNonIndex
    extends QuoteFilter {
        private QuoteFilterNonIndex() {
        }

        @Override
        public boolean isAcceptable(Quote quote) {
            return !quote.getStock().isIndex();
        }

        public String toString() {
            return QuoteFilterFactory.NON_INDEX;
        }
    }

    private static final class QuoteFilterIndex
    extends QuoteFilter {
        private QuoteFilterIndex() {
        }

        @Override
        public boolean isAcceptable(Quote quote) {
            return quote.getStock().isIndex();
        }

        public String toString() {
            return QuoteFilterFactory.INDEX;
        }
    }

    private static final class QuoteFilterLosers
    extends QuoteFilter {
        private QuoteFilterLosers() {
        }

        @Override
        public boolean isAcceptable(Quote quote) {
            return quote.getChange().doubleValue() < 0.0;
        }

        public String toString() {
            return QuoteFilterFactory.LOSERS;
        }
    }

    private static final class QuoteFilterGainers
    extends QuoteFilter {
        private QuoteFilterGainers() {
        }

        @Override
        public boolean isAcceptable(Quote quote) {
            return quote.getChange().doubleValue() >= 0.0;
        }

        public String toString() {
            return QuoteFilterFactory.GAINERS;
        }
    }

    private static final class QuoteFilterExchange
    extends QuoteFilter {
        private Exchange fTargetExchange;

        QuoteFilterExchange(Exchange exchange) {
            this.fTargetExchange = exchange;
        }

        @Override
        public boolean isAcceptable(Quote quote) {
            return quote.getStock().getExchange() == this.fTargetExchange;
        }

        public String toString() {
            return this.fTargetExchange.toString();
        }
    }

    private static class QuoteFilterAcceptAll
    extends QuoteFilter {
        private final String fText;

        QuoteFilterAcceptAll(String string) {
            this.fText = string;
        }

        @Override
        public boolean isAcceptable(Quote quote) {
            return true;
        }

        public String toString() {
            return this.fText;
        }
    }
}

