/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.quotes;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.quotes.ColorTip;
import hirondelle.stocks.quotes.Quote;
import hirondelle.stocks.table.QuoteFilter;
import hirondelle.stocks.table.QuoteFilterFactory;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class SummaryView
extends JPanel
implements PropertyChangeListener {
    private CurrentPortfolio fCurrentPortfolio;
    private QuoteFilterFactory fQuoteFilterFactory;
    private Collection<Quote> fQuotes;
    private JLabel fBookValue;
    private JLabel fCurrentValue;
    private JLabel fProfit;
    private JLabel fPercentageProfit;
    private JLabel fTimeLastUpdate;
    private JLabel fStatusMessage;
    private static final Logger fLogger = Util.getLogger(SummaryView.class);

    public SummaryView(CurrentPortfolio currentPortfolio, QuoteFilterFactory quoteFilterFactory) {
        Args.checkForNull(currentPortfolio);
        this.fCurrentPortfolio = currentPortfolio;
        this.fQuoteFilterFactory = quoteFilterFactory;
        this.fQuoteFilterFactory.addPropertyChangeListener(this);
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        this.add(this.getSummaryFields());
        this.add(Box.createVerticalStrut(5));
        this.add(this.getTimeLastUpdateField());
        this.add(Box.createVerticalGlue());
        this.add(this.getStatusField());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        boolean bl2 = bl = !propertyChangeEvent.getPropertyName().equals("SelectedFilter");
        if (bl) {
            fLogger.finer("SummaryView DISCARDING event...");
        } else {
            fLogger.finer("SummaryView processing event...");
            this.updateView();
        }
    }

    void setQuotes(Collection<Quote> collection) {
        this.fQuotes = collection;
        ColorTip colorTip = new ColorTip(0, 2, this.fTimeLastUpdate, Color.yellow);
        colorTip.start();
        this.updateView();
    }

    void showStatusMessage(String string) {
        Args.checkForContent(string);
        this.fStatusMessage.setText(string);
    }

    private JComponent getSummaryFields() {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 0);
        jPanel.setLayout(boxLayout);
        jPanel.add(this.getValueFields());
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.getProfitFields());
        return jPanel;
    }

    private JComponent getValueFields() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.fBookValue = UiUtil.addSimpleDisplayField(jPanel, "Book Value", null, UiUtil.getConstraints(0, 0), false);
        this.fBookValue.setToolTipText("Acquisition cost of the portfolio");
        this.fCurrentValue = UiUtil.addSimpleDisplayField(jPanel, "Current Value", null, UiUtil.getConstraints(1, 0), false);
        this.fCurrentValue.setToolTipText("Current value of the portfolio");
        return jPanel;
    }

    private JComponent getProfitFields() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.fProfit = UiUtil.addSimpleDisplayField(jPanel, "Profit", null, UiUtil.getConstraints(0, 0), false);
        this.fProfit.setToolTipText("Current value minus book value");
        this.fPercentageProfit = UiUtil.addSimpleDisplayField(jPanel, "% Profit", null, UiUtil.getConstraints(1, 0), false);
        this.fPercentageProfit.setToolTipText("Profit divided by book value, as percent");
        return jPanel;
    }

    private JComponent getTimeLastUpdateField() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.fTimeLastUpdate = UiUtil.addSimpleDisplayField(jPanel, "Last Update", null, UiUtil.getConstraints(0, 0), false);
        return jPanel;
    }

    private JComponent getStatusField() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.fStatusMessage = UiUtil.addSimpleDisplayField(jPanel, "Status", null, UiUtil.getConstraints(0, 0), false);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private void updateView() {
        QuoteFilter quoteFilter = this.fQuoteFilterFactory.getSelectedFilter();
        List<Quote> list = quoteFilter.sift(this.fQuotes);
        this.fBookValue.setText(this.getBookValue(list));
        this.fCurrentValue.setText(this.getCurrentValue(list));
        this.fProfit.setText(this.getProfit(list));
        this.fPercentageProfit.setText(this.getPercentageProfit(list));
        this.fTimeLastUpdate.setText(UiUtil.getLocalizedTime(new Date()));
    }

    private String getBookValue(Collection<Quote> collection) {
        BigDecimal bigDecimal = this.fCurrentPortfolio.getPortfolio().getBookValue(collection);
        return UiUtil.getLocalizedInteger(bigDecimal);
    }

    private String getCurrentValue(Collection<Quote> collection) {
        BigDecimal bigDecimal = this.fCurrentPortfolio.getPortfolio().getCurrentValue(collection);
        return UiUtil.getLocalizedInteger(bigDecimal);
    }

    private String getProfit(Collection<Quote> collection) {
        BigDecimal bigDecimal = this.fCurrentPortfolio.getPortfolio().getProfit(collection);
        return UiUtil.getLocalizedInteger(bigDecimal);
    }

    private String getPercentageProfit(Collection<Quote> collection) {
        BigDecimal bigDecimal = this.fCurrentPortfolio.getPortfolio().getPercentageProfit(collection);
        return UiUtil.getLocalizedPercent(bigDecimal);
    }
}

