/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.quotes;

import hirondelle.stocks.quotes.Exchange;
import hirondelle.stocks.util.EqualsUtil;
import hirondelle.stocks.util.HashCodeUtil;
import hirondelle.stocks.util.Util;
import java.math.BigDecimal;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public final class Stock
implements Comparable<Stock> {
    private final String fName;
    private final String fTicker;
    private final Exchange fExchange;
    private final Integer fNumShares;
    private final BigDecimal fAveragePrice;
    private static final Logger fLogger = Util.getLogger(Stock.class);
    private static final String FIELD_DELIMITER = ":";

    public Stock(String string, String string2, Exchange exchange, Integer n, BigDecimal bigDecimal) {
        this.fName = string;
        this.fTicker = string2;
        this.fExchange = exchange;
        this.fNumShares = n;
        this.fAveragePrice = bigDecimal;
        this.validateState();
    }

    public Stock valueOf(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_DELIMITER);
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            Exchange exchange = Exchange.valueFrom(stringTokenizer.nextToken());
            Integer n = Integer.valueOf(stringTokenizer.nextToken());
            BigDecimal bigDecimal = new BigDecimal(stringTokenizer.nextToken());
            return new Stock(string3, string2, exchange, n, bigDecimal);
        }
        catch (NoSuchElementException noSuchElementException) {
            fLogger.severe("Cannot parse into Stock object: \"" + string + "\"");
            throw noSuchElementException;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.fTicker).append(FIELD_DELIMITER);
        stringBuilder.append(this.fName).append(FIELD_DELIMITER);
        stringBuilder.append(this.fExchange).append(FIELD_DELIMITER);
        stringBuilder.append(this.fNumShares).append(FIELD_DELIMITER);
        stringBuilder.append(this.fAveragePrice);
        return stringBuilder.toString();
    }

    public static boolean isValidInput(List<String> list, String string, String string2, Exchange exchange, Integer n, BigDecimal bigDecimal) {
        if (list == null) {
            throw new IllegalArgumentException("List for error messages must be non-null.");
        }
        if (!list.isEmpty()) {
            throw new IllegalArgumentException("List for error messages must be initially empty.");
        }
        if (!Stock.isValidName(string)) {
            list.add("Name must have content.");
        }
        if (!Stock.isValidTicker(string2)) {
            String string3 = "Ticker symbols must have 1..20 characters, which are only letters, periods, underscores, and ^.";
            list.add(string3);
        }
        if (!Stock.isValidExchange(exchange)) {
            list.add("An exchange must be selected.");
        }
        if (!Stock.isValidNumShares(n)) {
            list.add("Quantity must not be null.");
        }
        if (!Stock.isValidAveragePrice(bigDecimal)) {
            list.add("Average price must be zero or positive.");
        }
        return list.isEmpty();
    }

    public String getName() {
        return this.fName;
    }

    public String getTicker() {
        return this.fTicker;
    }

    public Exchange getExchange() {
        return this.fExchange;
    }

    public Integer getNumShares() {
        return this.fNumShares;
    }

    public BigDecimal getAveragePrice() {
        return this.fAveragePrice;
    }

    public BigDecimal getBookValue() {
        BigDecimal bigDecimal = new BigDecimal(this.getNumShares().toString());
        return bigDecimal.multiply(this.getAveragePrice());
    }

    public boolean isIndex() {
        return this.fTicker.startsWith("^");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Stock)) {
            return false;
        }
        Stock stock = (Stock)object;
        return EqualsUtil.areEqual(this.fName, stock.fName) && EqualsUtil.areEqual(this.fTicker, stock.fTicker) && EqualsUtil.areEqual(this.fExchange, stock.fExchange) && EqualsUtil.areEqual(this.fNumShares, stock.fNumShares) && EqualsUtil.areEqual(this.fAveragePrice, stock.fAveragePrice);
    }

    public int hashCode() {
        int n = 23;
        n = HashCodeUtil.hash(n, this.fName);
        n = HashCodeUtil.hash(n, this.fTicker);
        n = HashCodeUtil.hash(n, this.fExchange);
        n = HashCodeUtil.hash(n, this.fNumShares);
        n = HashCodeUtil.hash(n, this.fAveragePrice);
        return n;
    }

    @Override
    public int compareTo(Stock stock) {
        if (this == stock) {
            return 0;
        }
        if (!this.isIndex() && stock.isIndex()) {
            return 1;
        }
        if (this.isIndex() && !stock.isIndex()) {
            return -1;
        }
        int n = this.fName.compareTo(stock.fName);
        if (n != 0) {
            return n;
        }
        n = this.fTicker.compareTo(stock.fTicker);
        if (n != 0) {
            return n;
        }
        n = this.fExchange.compareTo(stock.fExchange);
        if (n != 0) {
            return n;
        }
        n = this.fNumShares.compareTo(stock.fNumShares);
        if (n != 0) {
            return n;
        }
        n = this.fAveragePrice.compareTo(stock.fAveragePrice);
        if (n != 0) {
            return n;
        }
        assert (this.equals(stock)) : "compareTo inconsistent with equals.";
        return 0;
    }

    private void validateState() {
        boolean bl;
        boolean bl2 = bl = Stock.isValidName(this.fName) && Stock.isValidTicker(this.fTicker) && Stock.isValidExchange(this.fExchange) && Stock.isValidNumShares(this.fNumShares) && Stock.isValidAveragePrice(this.fAveragePrice);
        if (!bl) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    private static boolean isValidName(String string) {
        return Util.textHasContent(string);
    }

    private static boolean isValidTicker(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0 || string2.length() > 20) {
            return false;
        }
        boolean bl = true;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (!Character.isLetter(c) && c != '.' && c != '_' && c != '^') {
                bl = false;
            }
            c = stringCharacterIterator.next();
        }
        return bl;
    }

    private static boolean isValidExchange(Exchange exchange) {
        return exchange != null;
    }

    private static boolean isValidNumShares(Integer n) {
        return n != null;
    }

    private static boolean isValidAveragePrice(BigDecimal bigDecimal) {
        return bigDecimal != null && !(bigDecimal.doubleValue() < 0.0);
    }
}

