/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.quotes;

import hirondelle.stocks.quotes.Quote;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Consts;
import hirondelle.stocks.util.DataAccessException;
import hirondelle.stocks.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.ProgressMonitorInputStream;

public final class QuotesDAO {
    private static final boolean OFF_LINE = Boolean.getBoolean("offline");
    private Collection<Stock> fStocks;
    private boolean fUseMonitor;
    private static final Logger fLogger = Logger.getLogger(QuotesDAO.class.getPackage().getName());
    private static final String fYAHOO_URL_START = "http://quote.yahoo.com/d/quotes.csv?s=";
    private static final String fYAHOO_URL_END = "&f=sl1d1t1c1ohgv&e=.csv";
    private BigDecimal ZERO = Consts.ZERO_MONEY_WITH_DECIMAL;
    private int ROUND_MODE = 6;
    private int DECIMALS = 2;

    public QuotesDAO(UseMonitor useMonitor, Collection<Stock> collection) {
        Args.checkForNull(collection);
        this.fStocks = collection;
        this.fUseMonitor = useMonitor.getValue();
    }

    public List<Quote> getQuotes() throws DataAccessException {
        if (OFF_LINE) {
            System.out.println("HARD - fixed quote prices");
            return this.getStaticQuotes();
        }
        if (this.fStocks.size() == 0) {
            return Collections.emptyList();
        }
        URL uRL = null;
        try {
            uRL = new URL(this.getYahooUrlText());
        }
        catch (MalformedURLException malformedURLException) {
            fLogger.severe("Cannot create Yahoo Url using: " + this.getYahooUrlText());
        }
        List<Quote> list = this.getQueryResult(uRL);
        return list;
    }

    private String getYahooUrlText() {
        StringBuilder stringBuilder = new StringBuilder(fYAHOO_URL_START);
        Iterator<Stock> iterator = this.fStocks.iterator();
        while (iterator.hasNext()) {
            Stock stock = iterator.next();
            stringBuilder.append(this.getTickerForYahooUrl(stock));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(fYAHOO_URL_END);
        return stringBuilder.toString();
    }

    private String getTickerForYahooUrl(Stock stock) {
        StringBuilder stringBuilder = new StringBuilder(stock.getTicker());
        String string = stock.getExchange().getTickerSuffix();
        if (Util.textHasContent(string)) {
            stringBuilder.append(".");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private List<Quote> getQueryResult(URL uRL) throws DataAccessException {
        ArrayList<Quote> arrayList = new ArrayList<Quote>();
        List<String> list = this.getLines(uRL);
        int n = 0;
        for (Stock stock : this.fStocks) {
            arrayList.add(this.getQuote(stock, list.get(n)));
            ++n;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLines(URL uRL) throws DataAccessException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            try {
                inputStream = this.fUseMonitor ? new ProgressMonitorInputStream(null, "Fetching.", uRL.openStream()) : uRL.openStream();
                bufferedReader = new LineNumberReader(new InputStreamReader(inputStream));
                String string = null;
                while ((string = ((LineNumberReader)bufferedReader).readLine()) != null) {
                    arrayList.add(string);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new DataAccessException("Please connect to the Web. Cannot access Yahoo.", iOException);
        }
        return arrayList;
    }

    private Quote getQuote(Stock stock, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = this.parseTicker(stringTokenizer.nextToken());
        if (!string2.startsWith(stock.getTicker())) {
            fLogger.severe("Invalid ticker-exchange? Expected line for " + stock.getTicker() + ", but received: " + string);
        }
        BigDecimal bigDecimal = this.parsePrice(stringTokenizer.nextToken());
        bigDecimal = bigDecimal.setScale(2, this.ROUND_MODE);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        BigDecimal bigDecimal2 = this.parsePriceChange(stringTokenizer.nextToken());
        bigDecimal2 = bigDecimal2.setScale(2, 6);
        return new Quote(stock, bigDecimal, bigDecimal2);
    }

    private BigDecimal parsePrice(String string) {
        BigDecimal bigDecimal = this.ZERO;
        BigDecimal bigDecimal2 = this.ZERO;
        BigDecimal bigDecimal3 = this.ZERO;
        BigDecimal bigDecimal4 = this.ZERO;
        if ((string = string.trim()).indexOf(47) != -1) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreElements()) {
                object = stringTokenizer.nextToken();
                if (((String)object).indexOf(47) == -1) {
                    bigDecimal2 = new BigDecimal((String)object);
                    continue;
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer((String)object, "/");
                bigDecimal3 = new BigDecimal(stringTokenizer2.nextToken());
                bigDecimal4 = new BigDecimal(stringTokenizer2.nextToken());
            }
            if (!bigDecimal4.equals(this.ZERO)) {
                object = bigDecimal3.divide(bigDecimal4, this.ROUND_MODE).setScale(this.DECIMALS, this.ROUND_MODE);
                bigDecimal = bigDecimal2.add((BigDecimal)object);
            } else {
                bigDecimal = bigDecimal2;
            }
        } else {
            bigDecimal = new BigDecimal(string);
        }
        return bigDecimal;
    }

    private BigDecimal parsePriceChange(String string) {
        BigDecimal bigDecimal = this.ZERO;
        BigDecimal bigDecimal2 = this.ZERO;
        if ((string = string.trim()).startsWith("+")) {
            bigDecimal2 = new BigDecimal("1");
        } else if (string.startsWith("-")) {
            bigDecimal2 = new BigDecimal("-1");
        } else {
            return bigDecimal;
        }
        String string2 = string.substring(1);
        bigDecimal = bigDecimal2.multiply(this.parsePrice(string2));
        return bigDecimal;
    }

    private String parseTicker(String string) {
        return string.replaceAll("\"", "");
    }

    private List<Quote> getStaticQuotes() {
        ArrayList<Quote> arrayList = new ArrayList<Quote>();
        for (Stock stock : this.fStocks) {
            Quote quote = new Quote(stock, new BigDecimal("10.00"), new BigDecimal("-0.75"));
            arrayList.add(quote);
        }
        return arrayList;
    }

    public static enum UseMonitor {
        TRUE(true),
        FALSE(false);

        private final boolean fToggle;

        boolean getValue() {
            return this.fToggle;
        }

        private UseMonitor(boolean bl) {
            this.fToggle = bl;
        }
    }
}

