/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.quotes;

import hirondelle.stocks.quotes.Exchange;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.util.Consts;
import hirondelle.stocks.util.EqualsUtil;
import hirondelle.stocks.util.HashCodeUtil;
import hirondelle.stocks.util.Util;
import java.math.BigDecimal;

public final class Quote {
    private final Stock fStock;
    private final BigDecimal fCurrentPrice;
    private final BigDecimal fChange;
    private static final int DECIMALS = 2;
    private static int EXTRA_DECIMALS = 4;
    private static final int ROUNDING_MODE = 6;
    private static BigDecimal HUNDRED = new BigDecimal("100");
    private static final BigDecimal ZERO = Consts.ZERO_MONEY_WITH_DECIMAL;

    public Quote(Stock stock, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this.fStock = stock;
        this.fCurrentPrice = bigDecimal;
        this.fChange = bigDecimal2;
        this.validateState();
    }

    public BigDecimal getPercentChange() {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        if (!Util.isZeroMoney(this.getPrice())) {
            bigDecimal = this.getChange().divide(this.getOpeningPrice(), EXTRA_DECIMALS, 6);
            bigDecimal = this.rounded(bigDecimal.multiply(HUNDRED));
        }
        return bigDecimal;
    }

    public BigDecimal getCurrentValue() {
        BigDecimal bigDecimal = new BigDecimal(this.getStock().getNumShares().toString());
        return bigDecimal.multiply(this.getPrice());
    }

    public BigDecimal getProfit() {
        return this.getCurrentValue().subtract(this.getStock().getBookValue());
    }

    public BigDecimal getPercentProfit() {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        BigDecimal bigDecimal2 = this.getStock().getBookValue();
        if (!Util.isZeroMoney(bigDecimal2) && !Util.isZeroMoney(this.getPrice())) {
            bigDecimal = this.getProfit().divide(bigDecimal2, EXTRA_DECIMALS, 6);
            bigDecimal = this.rounded(bigDecimal.multiply(HUNDRED));
        }
        return bigDecimal;
    }

    public Stock getStock() {
        return this.fStock;
    }

    public BigDecimal getPrice() {
        return this.fCurrentPrice;
    }

    public BigDecimal getChange() {
        return this.fChange;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" {");
        stringBuilder.append(string);
        stringBuilder.append("Stock: ").append(this.fStock).append(string);
        stringBuilder.append("Opening Price: ").append(this.getOpeningPrice()).append(string);
        stringBuilder.append("Current Price: ").append(this.fCurrentPrice).append(string);
        stringBuilder.append("Change: ").append(this.fChange).append(string);
        stringBuilder.append("%Change: ").append(this.getPercentChange()).append(string);
        stringBuilder.append("%Profit: ").append(this.getPercentProfit()).append(string);
        stringBuilder.append("}");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Quote)) {
            return false;
        }
        Quote quote = (Quote)object;
        return EqualsUtil.areEqual(this.fStock, quote.fStock) && EqualsUtil.areEqual(this.fCurrentPrice, quote.fCurrentPrice) && EqualsUtil.areEqual(this.fChange, quote.fChange);
    }

    public int hashCode() {
        int n = 23;
        n = HashCodeUtil.hash(n, this.fStock);
        n = HashCodeUtil.hash(n, this.fCurrentPrice);
        n = HashCodeUtil.hash(n, this.fChange);
        return n;
    }

    private void validateState() {
        boolean bl;
        boolean bl2 = bl = this.fStock != null && this.fCurrentPrice != null && this.fCurrentPrice.compareTo(ZERO) >= 0 && this.fChange != null;
        if (!bl) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    private BigDecimal getOpeningPrice() {
        return this.getPrice().subtract(this.getChange());
    }

    private BigDecimal rounded(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 6);
    }

    private static void main(String ... stringArray) {
        Exchange exchange = Exchange.valueFrom("NYSE Stock Exchanges");
        Stock stock = new Stock("Blah", "BLA", exchange, 122, new BigDecimal("88"));
        Quote quote = new Quote(stock, new BigDecimal("118.53"), new BigDecimal("-0.17"));
        System.out.println(quote);
    }
}

