/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.quotes;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.preferences.QuoteTablePreferencesEditor;
import hirondelle.stocks.quotes.Quote;
import hirondelle.stocks.quotes.SummaryView;
import hirondelle.stocks.table.QuoteTable;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.DataAccessException;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public final class FetchQuotesAction
extends AbstractAction
implements Observer {
    private static final Logger fLogger = Util.getLogger(FetchQuotesAction.class);
    private CurrentPortfolio fCurrentPortfolio;
    private QuoteTablePreferencesEditor fQuoteTablePrefEditor;
    private QuoteTable fQuoteTable;
    private SummaryView fSummaryView;
    private Timer fTimer;
    private int fUpdateFreq;
    private static final int CONVERSION_FACTOR = 60000;
    private MessageFormat fTickerWarningFormat = new MessageFormat("Warning - no price for ticker {0} ({1})");

    public FetchQuotesAction(CurrentPortfolio currentPortfolio, QuoteTablePreferencesEditor quoteTablePreferencesEditor, QuoteTable quoteTable, SummaryView summaryView) {
        super("Update", UiUtil.getImageIcon("/toolbarButtonGraphics/general/Refresh"));
        Args.checkForNull(quoteTable);
        Args.checkForNull(summaryView);
        this.fCurrentPortfolio = currentPortfolio;
        this.fQuoteTablePrefEditor = quoteTablePreferencesEditor;
        this.fQuoteTable = quoteTable;
        this.fSummaryView = summaryView;
        this.putValue("ShortDescription", "Fetch updated stock quotes from web");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        this.putValue("LongDescription", "Retrieves fresh stock quotes and displays it to the user in a table.");
        this.putValue("MnemonicKey", new Integer(85));
        this.fUpdateFreq = this.fQuoteTablePrefEditor.getUpdateFrequency();
    }

    public void startTimer() {
        this.fQuoteTablePrefEditor.addObserver(this);
        this.fCurrentPortfolio.addObserver(this);
        this.fTimer = new Timer(this.fUpdateFreq * 60000, this);
        this.fTimer.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Fetching quotes from web.");
        this.fSummaryView.showStatusMessage("Fetching quotes...");
        HardWorker hardWorker = new HardWorker();
        hardWorker.execute();
    }

    @Override
    public void update(Observable observable, Object object) {
        fLogger.fine("Notified ...");
        if (observable == this.fQuoteTablePrefEditor) {
            boolean bl;
            fLogger.fine("By StocksTablePrefEditor.");
            boolean bl2 = bl = this.fQuoteTablePrefEditor.getUpdateFrequency() != this.fUpdateFreq;
            if (bl) {
                this.restartTimer();
            }
        } else {
            fLogger.fine("By Current Portfolio.");
            this.actionPerformed(null);
        }
    }

    private void showUpdated(List<Quote> list) {
        this.fQuoteTable.setQuoteTable(list);
        this.fSummaryView.setQuotes(list);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasNoZeroPrices(list, stringBuilder)) {
            this.fSummaryView.showStatusMessage("Done.");
        } else {
            this.fSummaryView.showStatusMessage(stringBuilder.toString());
        }
    }

    private boolean hasNoZeroPrices(List<Quote> list, StringBuilder stringBuilder) {
        for (Quote quote : list) {
            if (!Util.isZeroMoney(quote.getPrice())) continue;
            Object[] objectArray = new Object[]{quote.getStock().getTicker(), quote.getStock().getExchange()};
            stringBuilder.append(this.fTickerWarningFormat.format(objectArray));
            return false;
        }
        return true;
    }

    private void simulateLongDelay() {
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
    }

    private void restartTimer() {
        fLogger.fine("Resetting initial delay and delay to: " + this.fUpdateFreq + " minutes.");
        this.fUpdateFreq = this.fQuoteTablePrefEditor.getUpdateFrequency();
        this.fTimer.setInitialDelay(this.fUpdateFreq * 60000);
        this.fTimer.setDelay(this.fUpdateFreq * 60000);
        fLogger.fine("Cancelling pending tasks, and restarting timer...");
        this.fTimer.restart();
    }

    private final class HardWorker
    extends SwingWorker<List<Quote>, Void> {
        private HardWorker() {
        }

        @Override
        protected List<Quote> doInBackground() throws Exception {
            List<Quote> list = null;
            try {
                list = FetchQuotesAction.this.fCurrentPortfolio.getPortfolio().getQuotes();
            }
            catch (DataAccessException dataAccessException) {
                dataAccessException.printStackTrace();
            }
            return list;
        }

        @Override
        protected void done() {
            try {
                List list = (List)this.get();
                if (list != null) {
                    FetchQuotesAction.this.showUpdated(list);
                } else {
                    FetchQuotesAction.this.fSummaryView.showStatusMessage("Failed - Please connect to the web.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

