/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.quotes;

import hirondelle.stocks.util.FileUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public final class Exchange
implements Comparable<Exchange> {
    private final String fName;
    private final String fTickerSuffix;
    private static int fNextOrdinal = 0;
    private final int fOrdinal = fNextOrdinal++;
    private static final String TEXT_FILE_NAME = "exchanges.txt";
    private static final String COMMENT_CHAR = "#";
    private static final String NOT_AVAILABLE = "N/A";
    private static List<Exchange> fValues = new ArrayList<Exchange>();
    public static final List<Exchange> VALUES;

    public String getTickerSuffix() {
        return this.fTickerSuffix;
    }

    public String toString() {
        return this.fName;
    }

    public static Exchange valueFrom(String string) {
        if (string == null) {
            return null;
        }
        for (Exchange exchange : VALUES) {
            if (!string.equals(exchange.toString())) continue;
            return exchange;
        }
        throw new IllegalArgumentException("Cannot parse into Exchange object:" + string);
    }

    @Override
    public int compareTo(Exchange exchange) {
        return this.fOrdinal - exchange.fOrdinal;
    }

    private Exchange(String string, String string2) {
        this.fName = string;
        this.fTickerSuffix = string2;
    }

    private static void parseExchangesFromTextFile() {
        List<String> list = FileUtil.asLines(TEXT_FILE_NAME, Exchange.class);
        for (String string : list) {
            if (string.startsWith(COMMENT_CHAR)) continue;
            Exchange.parseExchange(string);
        }
    }

    private static void parseExchange(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string2 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string3 = Exchange.getSuffix(stringTokenizer.nextToken());
        Exchange exchange = new Exchange(string2, string3);
        fValues.add(exchange);
    }

    private static String getSuffix(String string) {
        if (string.equals(NOT_AVAILABLE)) {
            return "";
        }
        return Exchange.removeLeadingDot(string);
    }

    private static String removeLeadingDot(String string) {
        return string.substring(1);
    }

    static {
        Exchange.parseExchangesFromTextFile();
        VALUES = Collections.unmodifiableList(fValues);
    }
}

