/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.quotes;

import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import java.awt.Color;
import java.awt.EventQueue;
import java.util.logging.Logger;
import javax.swing.JComponent;

final class ColorTip {
    private final int fInitialDelay;
    private final int fActivationInterval;
    private final JComponent fComponent;
    private final Color fTemporaryColor;
    private final Color fOriginalColor;
    private final int fCONVERSION_FACTOR = 1000;
    private final boolean fOriginalOpacity;
    private static final Logger fLogger = Util.getLogger(ColorTip.class);

    ColorTip(int n, int n2, JComponent jComponent, Color color) {
        Args.checkForRange(n, 0, 60);
        Args.checkForRange(n2, 1, 60);
        Args.checkForNull(color);
        this.fInitialDelay = n;
        this.fActivationInterval = n2;
        this.fComponent = jComponent;
        this.fTemporaryColor = color;
        this.fOriginalColor = jComponent.getBackground();
        this.fOriginalOpacity = jComponent.isOpaque();
    }

    void start() {
        if (this.isSameColor()) {
            return;
        }
        Thread thread = new Thread(new Worker());
        thread.setDaemon(true);
        thread.start();
    }

    private boolean isSameColor() {
        return this.fTemporaryColor.equals(this.fOriginalColor);
    }

    private final class RevertColor
    implements Runnable {
        private RevertColor() {
        }

        @Override
        public void run() {
            ColorTip.this.fComponent.setBackground(ColorTip.this.fOriginalColor);
            ColorTip.this.fComponent.setOpaque(ColorTip.this.fOriginalOpacity);
        }
    }

    private final class ChangeColor
    implements Runnable {
        private ChangeColor() {
        }

        @Override
        public void run() {
            if (!ColorTip.this.fOriginalOpacity) {
                ColorTip.this.fComponent.setOpaque(true);
            }
            ColorTip.this.fComponent.setBackground(ColorTip.this.fTemporaryColor);
        }
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                fLogger.fine("Initial Sleeping...");
                Thread.sleep(1000 * ColorTip.this.fInitialDelay);
                EventQueue.invokeLater(new ChangeColor());
                fLogger.fine("Activation Sleeping...");
                Thread.sleep(1000 * ColorTip.this.fActivationInterval);
                EventQueue.invokeLater(new RevertColor());
            }
            catch (InterruptedException interruptedException) {
                fLogger.severe("Cannot sleep.");
            }
            fLogger.fine("Color worker done.");
        }
    }
}

