/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.preferences;

import hirondelle.stocks.preferences.OrderEditor;
import hirondelle.stocks.preferences.PreferencesEditor;
import hirondelle.stocks.table.QuoteField;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public final class QuoteTablePreferencesEditor
extends Observable
implements PreferencesEditor {
    private static final String TITLE = "Quote Table";
    private static final int MNEMONIC = 81;
    private static final String STOCKS_TABLE_NODE_NAME = "stocksmonitor/ui/prefs/StocksTable";
    private static final boolean HORIZONTAL_LINES_DEFAULT = true;
    private static final String HORIZONTAL_LINES_KEY = "HorizontalLines";
    private static final boolean VERTICAL_LINES_DEFAULT = true;
    private static final String VERTICAL_LINES_KEY = "VerticalLines";
    private static final int MAX_ROW_HEIGHT = 32;
    private static final int MIN_ROW_HEIGHT = 16;
    private static final int INITIAL_ROW_HEIGHT = 16;
    private static final int STEP_SIZE = 1;
    private static final int ROW_HEIGHT_DEFAULT = 16;
    private static final String ROW_HEIGHT_KEY = "RowHeight";
    private static final String SORT_FIELD_DEFAULT = "Stock";
    private static final String SORT_FIELD_KEY = "SortBy";
    private static final String COLUMN_ORDER_DEFAULT = "[Stock, Price, Change, %Change, Profit, %Profit]";
    private static final String COLUMN_ORDER_KEY = "ColumnOrder";
    private static final int MAX_UPDATE_FREQ = 60;
    private static final int MIN_UPDATE_FREQ = 1;
    private static final int UPDATE_FREQ_DEFAULT = 1;
    private static final String UPDATE_FREQ_KEY = "UpdateFrequency";
    private Preferences fPrefs = Preferences.userRoot().node("stocksmonitor/ui/prefs/StocksTable");
    private JCheckBox fHorizontalLines;
    private JCheckBox fVerticalLines;
    private SpinnerNumberModel fRowSizeModel;
    private JComboBox<QuoteField> fSortField;
    private OrderEditor fColumnOrderEditor;
    private SpinnerNumberModel fUpdateFreqModel;
    private static final Logger fLogger = Util.getLogger(QuoteTablePreferencesEditor.class);

    @Override
    public JComponent getUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.addSortField(jPanel);
        this.addHorizontalVerticalLines(jPanel);
        this.addRowHeight(jPanel);
        this.addUpdateFrequency(jPanel);
        this.addColumnOrder(jPanel);
        this.addRestore(jPanel);
        this.matchGuiToStoredPrefs();
        return jPanel;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public int getMnemonic() {
        return 81;
    }

    @Override
    public void savePreferences() {
        fLogger.fine("Updating table preferences.");
        this.fPrefs.putBoolean(HORIZONTAL_LINES_KEY, this.fHorizontalLines.isSelected());
        this.fPrefs.putBoolean(VERTICAL_LINES_KEY, this.fVerticalLines.isSelected());
        this.fPrefs.putInt(ROW_HEIGHT_KEY, this.fRowSizeModel.getNumber().intValue());
        this.fPrefs.put(SORT_FIELD_KEY, this.fSortField.getSelectedItem().toString());
        this.fPrefs.put(COLUMN_ORDER_KEY, this.fColumnOrderEditor.getItems().toString());
        this.fPrefs.putInt(UPDATE_FREQ_KEY, this.fUpdateFreqModel.getNumber().intValue());
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void matchGuiToDefaultPreferences() {
        this.fHorizontalLines.setSelected(true);
        this.fVerticalLines.setSelected(true);
        this.fRowSizeModel.setValue(new Integer(16));
        this.fSortField.setSelectedItem((Object)QuoteField.valueFrom(SORT_FIELD_DEFAULT));
        this.fColumnOrderEditor.setItems(this.parseRawColumnOrder(COLUMN_ORDER_DEFAULT));
        this.fUpdateFreqModel.setValue(new Integer(1));
    }

    public boolean hasHorizontalLines() {
        return this.fPrefs.getBoolean(HORIZONTAL_LINES_KEY, true);
    }

    public boolean hasVerticalLines() {
        return this.fPrefs.getBoolean(VERTICAL_LINES_KEY, true);
    }

    public int getRowHeight() {
        return this.fPrefs.getInt(ROW_HEIGHT_KEY, 16);
    }

    public QuoteField getSortField() {
        String string = this.fPrefs.get(SORT_FIELD_KEY, SORT_FIELD_DEFAULT);
        return QuoteField.valueFrom(string);
    }

    public Set<Object> getColumnOrder() {
        return this.parseRawColumnOrder(this.fPrefs.get(COLUMN_ORDER_KEY, COLUMN_ORDER_DEFAULT));
    }

    public int getUpdateFrequency() {
        return this.fPrefs.getInt(UPDATE_FREQ_KEY, 1);
    }

    private void addSortField(JPanel jPanel) {
        JLabel jLabel = new JLabel("Sort By:");
        jLabel.setDisplayedMnemonic(83);
        jLabel.setToolTipText("Always descending order");
        jPanel.add((Component)jLabel, this.getConstraints(0, 0));
        DefaultComboBoxModel<QuoteField> defaultComboBoxModel = new DefaultComboBoxModel<QuoteField>(QuoteField.values());
        this.fSortField = new JComboBox<QuoteField>(defaultComboBoxModel);
        jLabel.setLabelFor(this.fSortField);
        jPanel.add(this.fSortField, this.getConstraints(0, 1));
    }

    private void addHorizontalVerticalLines(JPanel jPanel) {
        JLabel jLabel = new JLabel("Show:");
        jPanel.add((Component)jLabel, this.getConstraints(1, 0));
        this.fHorizontalLines = new JCheckBox("Horizontal Lines");
        this.fHorizontalLines.setMnemonic(72);
        jPanel.add((Component)this.fHorizontalLines, this.getConstraints(1, 1));
        this.fVerticalLines = new JCheckBox("Vertical Lines");
        this.fVerticalLines.setMnemonic(86);
        jPanel.add((Component)this.fVerticalLines, this.getConstraints(1, 2, 2, 1));
    }

    private void addRowHeight(JPanel jPanel) {
        JLabel jLabel = new JLabel("Row Height:");
        jLabel.setDisplayedMnemonic(82);
        jLabel.setToolTipText("Height in pixels of table rows");
        jPanel.add((Component)jLabel, this.getConstraints(2, 0));
        this.fRowSizeModel = new SpinnerNumberModel(16, 16, 32, 1);
        JSpinner jSpinner = new JSpinner(this.fRowSizeModel);
        jLabel.setLabelFor(jSpinner);
        jPanel.add((Component)jSpinner, this.getConstraints(2, 1));
    }

    private void addUpdateFrequency(JPanel jPanel) {
        JLabel jLabel = new JLabel("Update Freq:");
        jLabel.setDisplayedMnemonic(85);
        jLabel.setToolTipText("Refresh interval in minutes");
        jPanel.add((Component)jLabel, this.getConstraints(2, 2));
        int n = 1;
        this.fUpdateFreqModel = new SpinnerNumberModel(n, 1, 60, 1);
        JSpinner jSpinner = new JSpinner(this.fUpdateFreqModel);
        jLabel.setLabelFor(jSpinner);
        jPanel.add((Component)jSpinner, this.getConstraints(2, 3));
    }

    private void addColumnOrder(JPanel jPanel) {
        JLabel jLabel = new JLabel("Column Order:");
        jLabel.setDisplayedMnemonic(67);
        GridBagConstraints gridBagConstraints = this.getConstraints(3, 0);
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.fColumnOrderEditor = new OrderEditor("Up", "Down");
        jLabel.setLabelFor(this.fColumnOrderEditor);
        GridBagConstraints gridBagConstraints2 = UiUtil.getConstraints(3, 1);
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.fColumnOrderEditor, gridBagConstraints2);
    }

    private void addRestore(JPanel jPanel) {
        JButton jButton = new JButton("Restore Defaults");
        jButton.setMnemonic(68);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuoteTablePreferencesEditor.this.matchGuiToDefaultPreferences();
            }
        });
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(3, 2, 2, 1);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    private Set<Object> parseRawColumnOrder(String string) {
        List<String> list = Util.getListFromString(string);
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        for (String string2 : list) {
            linkedHashSet.add((Object)QuoteField.valueFrom(string2));
        }
        assert (linkedHashSet.size() == QuoteField.values().length);
        return linkedHashSet;
    }

    private void matchGuiToStoredPrefs() {
        this.fHorizontalLines.setSelected(this.hasHorizontalLines());
        this.fVerticalLines.setSelected(this.hasVerticalLines());
        this.fRowSizeModel.setValue(new Integer(this.getRowHeight()));
        this.fSortField.setSelectedItem((Object)this.getSortField());
        this.fColumnOrderEditor.setItems(this.getColumnOrder());
        this.fUpdateFreqModel.setValue(new Integer(this.getUpdateFrequency()));
    }

    private GridBagConstraints getConstraints(int n, int n2) {
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(n, n2);
        this.addBottom(gridBagConstraints);
        return gridBagConstraints;
    }

    private GridBagConstraints getConstraints(int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(n, n2, n3, n4);
        this.addBottom(gridBagConstraints);
        return gridBagConstraints;
    }

    private void addBottom(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
    }

    private static void main(String ... stringArray) {
        QuoteTablePreferencesEditor quoteTablePreferencesEditor = new QuoteTablePreferencesEditor();
        try {
            quoteTablePreferencesEditor.fPrefs.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            fLogger.severe("Cannot access preferences.");
        }
        fLogger.severe("Done.");
    }
}

