/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.preferences;

import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class OrderEditor
extends JPanel {
    private String fUpButtonText;
    private String fDownButtonText;
    private Icon fUpButtonIcon;
    private Icon fDownButtonIcon;
    private JList fList;
    private DefaultListModel fModel;

    OrderEditor(String string, String string2) {
        Args.checkForContent(string);
        Args.checkForContent(string2);
        this.fUpButtonText = string;
        this.fDownButtonText = string2;
        this.buildGui();
    }

    OrderEditor(Icon icon, Icon icon2) {
        Args.checkForNull(icon);
        Args.checkForNull(icon2);
        this.fUpButtonIcon = icon;
        this.fDownButtonIcon = icon2;
        this.buildGui();
    }

    void setItems(Set<Object> set) {
        Args.checkForEmpty(set);
        this.fModel = new DefaultListModel();
        for (Object object : set) {
            this.fModel.addElement(object);
        }
        this.fList.setModel(this.fModel);
    }

    Set<Object> getItems() {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        ArrayList arrayList = Collections.list(this.fModel.elements());
        for (Object e : arrayList) {
            linkedHashSet.add(e);
        }
        assert (linkedHashSet.size() == this.fModel.size());
        return linkedHashSet;
    }

    @Override
    public void requestFocus() {
        this.fList.requestFocus();
    }

    private void buildGui() {
        this.setLayout(new BoxLayout(this, 0));
        this.fList = new JList();
        this.fList.setSelectionMode(0);
        this.fList.setSelectedIndex(0);
        this.fList.setToolTipText("Choose item, then move using buttons");
        this.add(Box.createHorizontalGlue());
        this.add(new JScrollPane(this.fList));
        this.add(Box.createHorizontalStrut(5));
        this.add(this.getButtons());
        this.add(Box.createHorizontalGlue());
        UiUtil.alignAllY(this, UiUtil.AlignY.CENTER);
    }

    private JComponent getButtons() {
        UpAction upAction = this.hasIcons() ? new UpAction(this.fUpButtonIcon) : new UpAction(this.fUpButtonText);
        JButton jButton = new JButton(upAction);
        DownAction downAction = this.hasIcons() ? new DownAction(this.fDownButtonIcon) : new DownAction(this.fDownButtonText);
        JButton jButton2 = new JButton(downAction);
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(jButton);
        arrayList.add(jButton2);
        JComponent jComponent = UiUtil.getCommandColumn(arrayList);
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return jComponent;
    }

    private void swapWithPredecessor() {
        int n = this.fList.getSelectedIndex();
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        Object e = this.fModel.getElementAt(n2);
        Object e2 = this.fModel.getElementAt(n);
        this.fModel.setElementAt(e2, n2);
        this.fModel.setElementAt(e, n);
        this.fList.setSelectedIndex(n2);
    }

    private void swapWithSuccessor() {
        int n = this.fList.getSelectedIndex();
        if (n == this.fModel.getSize() - 1) {
            return;
        }
        int n2 = n + 1;
        Object e = this.fModel.getElementAt(n2);
        Object e2 = this.fModel.getElementAt(n);
        this.fModel.setElementAt(e2, n2);
        this.fModel.setElementAt(e, n);
        this.fList.setSelectedIndex(n2);
    }

    private boolean hasIcons() {
        return this.fUpButtonIcon != null;
    }

    private boolean isSelectionPresent() {
        return !this.fList.getSelectionModel().isSelectionEmpty();
    }

    private final class DownAction
    extends EditAction {
        DownAction(String string) {
            super(string);
        }

        DownAction(Icon icon) {
            super(icon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrderEditor.this.swapWithSuccessor();
        }
    }

    private final class UpAction
    extends EditAction {
        UpAction(String string) {
            super(string);
        }

        UpAction(Icon icon) {
            super(icon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrderEditor.this.swapWithPredecessor();
        }
    }

    private abstract class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        EditAction(String string) {
            super(string);
            this.init();
        }

        EditAction(Icon icon) {
            super("", icon);
            this.init();
        }

        @Override
        public final void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(OrderEditor.this.isSelectionPresent());
        }

        private final void init() {
            this.setEnabled(false);
            OrderEditor.this.fList.getSelectionModel().addListSelectionListener(this);
        }
    }
}

