/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.preferences;

import java.awt.EventQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;

public final class OptionPaneExceptionHandler
extends Handler {
    private static final String TITLE = "Error Occured";

    public OptionPaneExceptionHandler() {
        this.setFormatter(new SimpleFormatter());
        this.setLevel(Level.SEVERE);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.showGui(logRecord);
        } else {
            EventQueue.invokeLater(new Worker(logRecord));
        }
    }

    public static void attachToRootLogger() {
        OptionPaneExceptionHandler optionPaneExceptionHandler = new OptionPaneExceptionHandler();
        Logger logger = Logger.getLogger("");
        logger.addHandler(optionPaneExceptionHandler);
    }

    private void showGui(LogRecord logRecord) {
        String string = this.getFormatter().formatMessage(logRecord);
        JOptionPane.showMessageDialog(null, string, TITLE, 0);
    }

    private class Worker
    implements Runnable {
        private LogRecord fLogRecord;

        Worker(LogRecord logRecord) {
            this.fLogRecord = logRecord;
        }

        @Override
        public void run() {
            OptionPaneExceptionHandler.this.showGui(this.fLogRecord);
        }
    }
}

