/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.preferences;

import hirondelle.stocks.preferences.OptionPaneExceptionHandler;
import hirondelle.stocks.preferences.PreferencesEditor;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class LoggingPreferencesEditor
implements PreferencesEditor {
    private static final String TITLE = "Logging";
    private static final int MNEMONIC = 76;
    private static final String EXPLANATION = "Temporarily override the configured log level for all known loggers and handlers. (Setting the log level here will affect only the currently running program. To change settings more permanently, edit the above-named log file.)";
    private JComboBox<Level> fLogLevel;
    private static final Logger fLogger = Util.getLogger(LoggingPreferencesEditor.class);
    private static List<Level> LEVELS = new ArrayList<Level>();

    @Override
    public int getMnemonic() {
        return 76;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public JComponent getUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.getLogFileUI());
        jPanel.add(this.getLogLevelUI());
        UiUtil.alignAllX(jPanel, UiUtil.AlignX.LEFT);
        return jPanel;
    }

    @Override
    public void matchGuiToDefaultPreferences() {
    }

    @Override
    public void savePreferences() {
    }

    public File getLogConfigFile() {
        File file = null;
        String string = System.getProperty("java.util.logging.config.file");
        if (string == null) {
            String string2 = System.getProperty("java.home");
            File file2 = new File(string2);
            File file3 = new File(file2, "lib");
            file = new File(file3, "logging.properties");
        } else {
            file = new File(string);
        }
        assert (file.exists());
        return file;
    }

    private void refreshLogFile() {
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration();
            OptionPaneExceptionHandler.attachToRootLogger();
        }
        catch (IOException iOException) {
            fLogger.log(Level.SEVERE, "Cannot re-read logging config file. Please verify file name.", iOException);
        }
    }

    private JComponent getLogFileUI() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Logging Config File"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.getLocation());
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.getRefresh());
        jPanel.add(Box.createVerticalStrut(5));
        UiUtil.alignAllX(jPanel, UiUtil.AlignX.CENTER);
        return jPanel;
    }

    private JComponent getLocation() {
        return UiUtil.getStandardTextArea(this.getLogConfigFile().toString());
    }

    private JComponent getRefresh() {
        JButton jButton = new JButton("Refresh Now");
        jButton.setMnemonic(82);
        jButton.setToolTipText("Refreshes the above logging config file");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoggingPreferencesEditor.this.refreshLogFile();
            }
        });
        return jButton;
    }

    private JComponent getLogLevelUI() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Temporary Log Level"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.getExplanation());
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.getLogLevel());
        jPanel.add(Box.createVerticalStrut(5));
        UiUtil.alignAllX(jPanel, UiUtil.AlignX.CENTER);
        return jPanel;
    }

    private JComponent getExplanation() {
        return UiUtil.getStandardTextArea(EXPLANATION);
    }

    private JComponent getLogLevel() {
        DefaultComboBoxModel<Level> defaultComboBoxModel = new DefaultComboBoxModel<Level>(LEVELS.toArray(new Level[0]));
        this.fLogLevel = new JComboBox<Level>(defaultComboBoxModel);
        this.fLogLevel.setToolTipText("Select an item to immediately update logging levels");
        this.fLogLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoggingPreferencesEditor.this.changeGlobalLoggingLevels();
            }
        });
        this.fLogLevel.setMaximumSize(new Dimension(100, 50));
        return this.fLogLevel;
    }

    private void changeGlobalLoggingLevels() {
        Level level = (Level)this.fLogLevel.getSelectedItem();
        Logger logger = Logger.getLogger("");
        for (Handler object : logger.getHandlers()) {
            if (object instanceof OptionPaneExceptionHandler) continue;
            object.setLevel(level);
        }
        logger.setLevel(level);
        ArrayList<String> arrayList = Collections.list(LogManager.getLogManager().getLoggerNames());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Logger logger2 = LogManager.getLogManager().getLogger(string);
            logger2.setLevel(level);
        }
    }

    static {
        LEVELS.add(Level.OFF);
        LEVELS.add(Level.FINEST);
        LEVELS.add(Level.FINER);
        LEVELS.add(Level.FINE);
        LEVELS.add(Level.CONFIG);
        LEVELS.add(Level.INFO);
        LEVELS.add(Level.WARNING);
        LEVELS.add(Level.SEVERE);
    }
}

