/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.preferences;

import hirondelle.stocks.preferences.PreferencesEditor;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.Theme;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.metal.MetalTheme;

public final class GeneralLookPreferencesEditor
extends Observable
implements PreferencesEditor {
    private static final String GENERAL_LOOK_NODE = "stocksmonitor/ui/prefs/GeneralLook";
    private Preferences fPrefs = Preferences.userRoot().node("stocksmonitor/ui/prefs/GeneralLook");
    private static final String TITLE = "General Look";
    private static final int MNEMONIC = 71;
    private static final boolean SHOW_TOOLBAR_DEFAULT = true;
    private static final String SHOW_TOOL_BAR_KEY = "ShowToolbar";
    private static final boolean USE_LARGE_ICONS_DEFAULT = false;
    private static final String USE_LARGE_ICONS = "UseLargeIcons";
    private static final String THEME_NAME_DEFAULT = "Default";
    private static final String THEME_NAME_KEY = "ThemeName";
    private JCheckBox fShowToolBar;
    private JCheckBox fLargeIcons;
    private JComboBox<MetalTheme> fThemes;
    private static final Logger fLogger = Util.getLogger(GeneralLookPreferencesEditor.class);

    @Override
    public JComponent getUI() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.addShowToolbarAndLargeIcons(jPanel);
        this.addTheme(jPanel);
        this.addRestoreDefaults(jPanel);
        UiUtil.addVerticalGridGlue(jPanel, 4);
        this.matchGuiToStoredPrefs();
        return jPanel;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public int getMnemonic() {
        return 71;
    }

    @Override
    public void savePreferences() {
        fLogger.fine("Updating general preferences.");
        this.fPrefs.putBoolean(SHOW_TOOL_BAR_KEY, this.fShowToolBar.isSelected());
        this.fPrefs.putBoolean(USE_LARGE_ICONS, this.fLargeIcons.isSelected());
        this.fPrefs.put(THEME_NAME_KEY, this.fThemes.getSelectedItem().toString());
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void matchGuiToDefaultPreferences() {
        this.fShowToolBar.setSelected(true);
        this.fLargeIcons.setSelected(false);
        this.fThemes.setSelectedItem(Theme.valueOf(THEME_NAME_DEFAULT));
    }

    public boolean hasShowToolBar() {
        return this.fPrefs.getBoolean(SHOW_TOOL_BAR_KEY, true);
    }

    public boolean hasLargeIcons() {
        return this.fPrefs.getBoolean(USE_LARGE_ICONS, false);
    }

    public MetalTheme getTheme() {
        String string = this.fPrefs.get(THEME_NAME_KEY, THEME_NAME_DEFAULT);
        return Theme.valueOf(string);
    }

    private void matchGuiToStoredPrefs() {
        this.fShowToolBar.setSelected(this.hasShowToolBar());
        this.fLargeIcons.setSelected(this.hasLargeIcons());
        this.fThemes.setSelectedItem(this.getTheme());
    }

    private void addShowToolbarAndLargeIcons(JPanel jPanel) {
        JLabel jLabel = new JLabel("Show:");
        jPanel.add((Component)jLabel, this.getConstraints(0, 0));
        this.fShowToolBar = new JCheckBox("Toolbar");
        this.fShowToolBar.setMnemonic(79);
        jPanel.add((Component)this.fShowToolBar, this.getConstraints(0, 1));
        JLabel jLabel2 = new JLabel("Icon Size:");
        jPanel.add((Component)jLabel2, this.getConstraints(1, 0));
        this.fLargeIcons = new JCheckBox("Use Large Icons");
        this.fLargeIcons.setMnemonic(85);
        jLabel2.setLabelFor(this.fLargeIcons);
        jPanel.add((Component)this.fLargeIcons, this.getConstraints(1, 1));
    }

    private void addTheme(JPanel jPanel) {
        JLabel jLabel = new JLabel("Theme:");
        jLabel.setDisplayedMnemonic(84);
        jPanel.add((Component)jLabel, this.getConstraints(2, 0));
        DefaultComboBoxModel<MetalTheme> defaultComboBoxModel = new DefaultComboBoxModel<MetalTheme>(Theme.VALUES.toArray(new MetalTheme[0]));
        this.fThemes = new JComboBox<MetalTheme>(defaultComboBoxModel);
        jLabel.setLabelFor(this.fThemes);
        jPanel.add(this.fThemes, this.getConstraints(2, 1));
    }

    private void addRestoreDefaults(JPanel jPanel) {
        JButton jButton = new JButton("Restore Defaults");
        jButton.setMnemonic(68);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralLookPreferencesEditor.this.matchGuiToDefaultPreferences();
            }
        });
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(3, 1);
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    private GridBagConstraints getConstraints(int n, int n2) {
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(n, n2);
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        return gridBagConstraints;
    }
}

