/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.preferences;

import hirondelle.stocks.preferences.PreferencesEditor;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.StandardEditor;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class EditUserPreferencesAction
extends AbstractAction {
    private JFrame fFrame;
    private List<PreferencesEditor> fPrefEditors;
    private static final Logger fLogger = Util.getLogger(EditUserPreferencesAction.class);
    private Editor fEditor;

    public EditUserPreferencesAction(JFrame jFrame, List<PreferencesEditor> list) {
        super("Preferences...", UiUtil.getEmptyIcon());
        Args.checkForNull(jFrame);
        Args.checkForNull(list);
        this.fFrame = jFrame;
        this.putValue("ShortDescription", "Update user preferences");
        this.putValue("LongDescription", "Allows user input of preferences.");
        this.putValue("MnemonicKey", new Integer(80));
        this.fPrefEditors = list;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Showing user preferences dialog.");
        if (this.fEditor == null) {
            this.fEditor = new Editor("Edit Preferences", this.fFrame);
        }
        this.fEditor.showDialog();
    }

    private JComponent getPrefEditors() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabPlacement(2);
        int n = 0;
        for (PreferencesEditor preferencesEditor : this.fPrefEditors) {
            JComponent jComponent = preferencesEditor.getUI();
            jComponent.setBorder(UiUtil.getStandardBorder());
            jTabbedPane.addTab(preferencesEditor.getTitle(), jComponent);
            jTabbedPane.setMnemonicAt(n, preferencesEditor.getMnemonic());
            ++n;
        }
        return jTabbedPane;
    }

    private void saveSettings() {
        fLogger.fine("User selected OK. Updating table preferences.");
        for (PreferencesEditor preferencesEditor : this.fPrefEditors) {
            preferencesEditor.savePreferences();
        }
    }

    private final class Editor
    extends StandardEditor {
        Editor(String string, JFrame jFrame) {
            super(string, jFrame, StandardEditor.CloseAction.HIDE);
        }

        @Override
        public JComponent getEditorUI() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(EditUserPreferencesAction.this.getPrefEditors());
            return jPanel;
        }

        @Override
        public void okAction() {
            EditUserPreferencesAction.this.saveSettings();
            this.dispose();
        }
    }
}

