/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.portfolio;

import hirondelle.stocks.portfolio.RegexInputVerifier;
import hirondelle.stocks.quotes.Exchange;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Consts;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.StandardEditor;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

final class StockEditor {
    private Stock fNewStock;
    private JTextField fNameField;
    private JTextField fTickerField;
    private JComboBox<Exchange> fExchangeField;
    private JTextField fQuantityField;
    private JTextField fAveragePriceField;
    private JFrame fFrame;

    StockEditor(JFrame jFrame) {
        Args.checkForNull(jFrame);
        this.fFrame = jFrame;
    }

    Stock addStock() {
        this.showDialog("Add New Stock", null);
        return this.fNewStock;
    }

    Stock changeStock(Stock stock) {
        Args.checkForNull(stock);
        this.showDialog("Change Stock", stock);
        return this.fNewStock;
    }

    private void showDialog(String string, Stock stock) {
        Editor editor = new Editor(string, this.fFrame, stock);
        editor.showDialog();
    }

    private JComponent getEditor(Stock stock) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.addCompanyName(jPanel, stock);
        this.addTickerField(jPanel, stock);
        this.addExchange(jPanel, stock);
        this.addQuantity(jPanel, stock);
        this.addAveragePrice(jPanel, stock);
        return jPanel;
    }

    private void initNewStock(StandardEditor standardEditor) {
        if (this.hasErrorMessage()) {
            String string = "Please correct the input error before proceeding.";
            JOptionPane.showMessageDialog(this.fFrame, string, "Invalid Input", 1);
            return;
        }
        String string = this.fNameField.getText();
        String string2 = this.fTickerField.getText();
        Exchange exchange = Exchange.valueFrom(this.fExchangeField.getSelectedItem().toString());
        Integer n = null;
        n = Util.textHasContent(this.fQuantityField.getText()) ? Integer.valueOf(this.fQuantityField.getText()) : Consts.ZERO;
        BigDecimal bigDecimal = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        bigDecimal = Util.textHasContent(this.fAveragePriceField.getText()) ? new BigDecimal(this.fAveragePriceField.getText()) : new BigDecimal("0.00");
        if (Stock.isValidInput(arrayList, string, string2, exchange, n, bigDecimal)) {
            this.fNewStock = new Stock(string, string2, exchange, n, bigDecimal);
            standardEditor.dispose();
        } else {
            Object[] objectArray = arrayList.toArray();
            JOptionPane.showMessageDialog(this.fFrame, objectArray, "Invalid Input", 1);
        }
    }

    private boolean hasErrorMessage() {
        return this.fNameField.getText().startsWith("INVALID: ") || this.fTickerField.getText().startsWith("INVALID: ") || this.fQuantityField.getText().startsWith("INVALID: ") || this.fAveragePriceField.getText().startsWith("INVALID: ");
    }

    private void addCompanyName(JPanel jPanel, Stock stock) {
        this.fNameField = UiUtil.addSimpleEntryField(jPanel, "Company Name:", stock == null ? null : stock.getName(), 67, UiUtil.getConstraints(0, 0), "No spaces on the ends, and at least one character");
        this.fNameField.setInputVerifier(RegexInputVerifier.TEXT);
    }

    private void addTickerField(JPanel jPanel, Stock stock) {
        this.fTickerField = UiUtil.addSimpleEntryField(jPanel, "Ticker:", stock == null ? null : stock.getTicker(), 84, UiUtil.getConstraints(1, 0), "No spaces on the ends, 1-20 characters: letters, periods, underscore and ^");
        String string = "(\\^)?([A-Za-z._]){1,20}";
        RegexInputVerifier regexInputVerifier = new RegexInputVerifier(Pattern.compile(string), RegexInputVerifier.UseToolTip.FALSE);
        this.fTickerField.setInputVerifier(regexInputVerifier);
    }

    private void addExchange(JPanel jPanel, Stock stock) {
        JLabel jLabel = new JLabel("Exchange:");
        jLabel.setDisplayedMnemonic(88);
        jPanel.add((Component)jLabel, UiUtil.getConstraints(2, 0));
        DefaultComboBoxModel<Exchange> defaultComboBoxModel = new DefaultComboBoxModel<Exchange>(Exchange.VALUES.toArray(new Exchange[0]));
        this.fExchangeField = new JComboBox<Exchange>(defaultComboBoxModel);
        if (stock != null) {
            this.fExchangeField.setSelectedItem(stock.getExchange());
        }
        jLabel.setLabelFor(this.fExchangeField);
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(2, 1);
        gridBagConstraints.fill = 2;
        jPanel.add(this.fExchangeField, gridBagConstraints);
    }

    private void addQuantity(JPanel jPanel, Stock stock) {
        this.fQuantityField = UiUtil.addSimpleEntryField(jPanel, "Quantity:", stock == null ? null : stock.getNumShares().toString(), 81, UiUtil.getConstraints(3, 0), "Zero or Integer (possible leading minus sign)");
        this.fQuantityField.setInputVerifier(RegexInputVerifier.INTEGER);
    }

    private void addAveragePrice(JPanel jPanel, Stock stock) {
        this.fAveragePriceField = UiUtil.addSimpleEntryField(jPanel, "Average Price:", stock == null ? null : stock.getAveragePrice().toString(), 65, UiUtil.getConstraints(4, 0), "Zero or Positive Number (two decimals optional)");
        this.fAveragePriceField.setInputVerifier(RegexInputVerifier.NON_NEGATIVE_MONEY);
    }

    private final class Editor
    extends StandardEditor {
        private Stock fInitialValue;

        Editor(String string, JFrame jFrame, Stock stock) {
            super(string, jFrame, StandardEditor.CloseAction.HIDE);
            this.fInitialValue = stock;
        }

        @Override
        protected JComponent getEditorUI() {
            return StockEditor.this.getEditor(this.fInitialValue);
        }

        @Override
        protected void okAction() {
            StockEditor.this.initNewStock(this);
        }
    }
}

