/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.portfolio;

import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

final class RegexInputVerifier
extends InputVerifier {
    static final String ERROR_MESSAGE_START = "INVALID: ";
    private Matcher fMatcher;
    private boolean fUseToolTip;
    private static final String TEXT_FIELD = "^(\\S)(.){1,75}(\\S)$";
    private static final String NON_NEGATIVE_INTEGER_FIELD = "(\\d){1,9}";
    private static final String INTEGER_FIELD = "(-)?(\\d){1,9}";
    private static final String NON_NEGATIVE_FLOATING_POINT_FIELD = "(\\d){1,10}\\.(\\d){1,10}";
    private static final String FLOATING_POINT_FIELD = "(-)?(\\d){1,10}\\.(\\d){1,10}";
    private static final String NON_NEGATIVE_MONEY_FIELD = "(\\d){1,15}(\\.(\\d){2})?";
    private static final String MONEY_FIELD = "(-)?(\\d){1,15}(\\.(\\d){2})?";
    static final RegexInputVerifier INTEGER = new RegexInputVerifier(Pattern.compile("(-)?(\\d){1,9}"), UseToolTip.FALSE);
    static final RegexInputVerifier NON_NEGATIVE_INTEGER = new RegexInputVerifier(Pattern.compile("(\\d){1,9}"), UseToolTip.FALSE);
    static final RegexInputVerifier TEXT = new RegexInputVerifier(Pattern.compile("^(\\S)(.){1,75}(\\S)$"), UseToolTip.FALSE);
    static final RegexInputVerifier FLOATING_POINT = new RegexInputVerifier(Pattern.compile("(-)?(\\d){1,10}\\.(\\d){1,10}"), UseToolTip.FALSE);
    static final RegexInputVerifier NON_NEGATIVE_FLOATING_POINT = new RegexInputVerifier(Pattern.compile("(\\d){1,10}\\.(\\d){1,10}"), UseToolTip.FALSE);
    static final RegexInputVerifier MONEY = new RegexInputVerifier(Pattern.compile("(-)?(\\d){1,15}(\\.(\\d){2})?"), UseToolTip.FALSE);
    static final RegexInputVerifier NON_NEGATIVE_MONEY = new RegexInputVerifier(Pattern.compile("(\\d){1,15}(\\.(\\d){2})?"), UseToolTip.FALSE);
    private static JFrame fFrame;
    private static JTextField fRegexField;
    private static JTextField fInputField;

    RegexInputVerifier(Pattern pattern, UseToolTip useToolTip) {
        Args.checkForContent(pattern.pattern());
        this.fMatcher = pattern.matcher("");
        this.fUseToolTip = useToolTip.getValue();
    }

    @Override
    public boolean shouldYieldFocus(JComponent jComponent) {
        boolean bl = super.shouldYieldFocus(jComponent);
        if (!bl) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            this.notifyUserOfError(jTextComponent);
        }
        return true;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        boolean bl = false;
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        this.fMatcher.reset(jTextComponent.getText());
        if (this.fMatcher.matches()) {
            bl = true;
        }
        return bl;
    }

    private void notifyUserOfError(JTextComponent jTextComponent) {
        if (!this.isShowingErrorMessage(jTextComponent)) {
            UiUtil.beep();
            this.showErrorMessage(jTextComponent);
        }
    }

    private boolean isShowingErrorMessage(JTextComponent jTextComponent) {
        return jTextComponent.getText().startsWith(ERROR_MESSAGE_START);
    }

    private void showErrorMessage(JTextComponent jTextComponent) {
        StringBuilder stringBuilder = new StringBuilder(ERROR_MESSAGE_START);
        stringBuilder.append("\"");
        stringBuilder.append(jTextComponent.getText());
        stringBuilder.append("\"");
        if (this.fUseToolTip) {
            stringBuilder.append(jTextComponent.getToolTipText());
        }
        jTextComponent.setText(stringBuilder.toString());
    }

    public static void main(String ... stringArray) {
        RegexInputVerifier.showGuiForExercisingVerifier();
    }

    private static void showGuiForExercisingVerifier() {
        fFrame = new JFrame("Test Regular Expressions - javapractices.com");
        fFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(UiUtil.getStandardBorder());
        jPanel.add(RegexInputVerifier.getEditor());
        jPanel.add(RegexInputVerifier.getCommandRow());
        fFrame.getContentPane().add(jPanel);
        UiUtil.centerAndShow(fFrame);
    }

    private static JComponent getEditor() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(0, 0);
        gridBagConstraints.fill = 2;
        fRegexField = UiUtil.addSimpleEntryField(jPanel, "Regular Expression:", null, 82, gridBagConstraints, "Double backslashes are not needed. Set Regex to init.");
        gridBagConstraints = UiUtil.getConstraints(1, 0);
        gridBagConstraints.fill = 2;
        fInputField = UiUtil.addSimpleEntryField(jPanel, "Test Input:", null, 73, gridBagConstraints, "This text is verified versus the regular expression");
        UiUtil.addVerticalGridGlue(jPanel, 2);
        return jPanel;
    }

    private static JComponent getCommandRow() {
        JButton jButton = new JButton("Set Regex");
        jButton.setMnemonic(83);
        jButton.setToolTipText("Start testing input versus the above regular expression");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegexInputVerifier.setRegex();
            }
        });
        JButton jButton2 = new JButton("Test");
        jButton2.setMnemonic(84);
        jButton2.setToolTipText("Exercises verifier by simply receiving focus");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        JButton jButton3 = new JButton("Close");
        jButton3.setMnemonic(67);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fFrame.dispose();
            }
        });
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(jButton);
        arrayList.add(jButton2);
        arrayList.add(jButton3);
        return UiUtil.getCommandRow(arrayList);
    }

    private static void setRegex() {
        Pattern pattern = Pattern.compile(fRegexField.getText());
        RegexInputVerifier regexInputVerifier = new RegexInputVerifier(pattern, UseToolTip.FALSE);
        fInputField.setInputVerifier(regexInputVerifier);
    }

    static enum UseToolTip {
        TRUE(true),
        FALSE(false);

        private boolean fToggle;

        boolean getValue() {
            return this.fToggle;
        }

        private UseToolTip(boolean bl) {
            this.fToggle = bl;
        }
    }
}

