/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.portfolio;

import hirondelle.stocks.portfolio.Portfolio;
import hirondelle.stocks.quotes.Exchange;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public final class PortfolioDAO {
    private static final Logger fLogger = Util.getLogger(PortfolioDAO.class);
    private static final String STOCKS_KEY = "stocks";
    private static final String DEFAULT_PORTFOLIO_NAME_KEY = "DefaultPortfolioName";

    public void saveAs(Portfolio portfolio) {
        if (this.isStored(portfolio.getName())) {
            String string = "Cannot save; name already exists: " + portfolio.getName();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            throw illegalArgumentException;
        }
        PortfolioDAO.getPortfoliosRootPref().node(portfolio.getName());
        this.save(portfolio);
    }

    public void save(Portfolio portfolio) {
        Preferences preferences = this.getExistingPortfolioPref(portfolio.getName());
        preferences.put(STOCKS_KEY, portfolio.getStocks().toString());
    }

    public void saveAsDefault(Portfolio portfolio) {
        Preferences preferences = PortfolioDAO.getPortfoliosRootPref();
        preferences.put(DEFAULT_PORTFOLIO_NAME_KEY, portfolio.getName());
    }

    public Portfolio fetchDefaultPortfolio() {
        Preferences preferences = PortfolioDAO.getPortfoliosRootPref();
        String string = preferences.get(DEFAULT_PORTFOLIO_NAME_KEY, "");
        if (Util.textHasContent(string)) {
            return this.fetch(string);
        }
        return Portfolio.getUntitledPortfolio();
    }

    public Collection<String> fetchAllPortfolioNames() {
        String[] stringArray = null;
        try {
            stringArray = PortfolioDAO.getPortfoliosRootPref().childrenNames();
        }
        catch (BackingStoreException backingStoreException) {
            fLogger.log(Level.SEVERE, "Cannot access backing store.", backingStoreException);
        }
        return new TreeSet<String>(Arrays.asList(stringArray));
    }

    public boolean isValidCandidateName(String string) {
        Collection<String> collection = this.fetchAllPortfolioNames();
        return Util.textHasContent(string) && !collection.contains(string);
    }

    public Portfolio fetch(String string) {
        Preferences preferences = this.getExistingPortfolioPref(string);
        return new Portfolio(string, this.getStocks(preferences));
    }

    public void delete(Portfolio portfolio) {
        String string = this.fetchDefaultPortfolio().getName();
        if (portfolio.getName().equals(string)) {
            PortfolioDAO.getPortfoliosRootPref().remove(DEFAULT_PORTFOLIO_NAME_KEY);
        }
        Preferences preferences = this.getExistingPortfolioPref(portfolio.getName());
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            fLogger.log(Level.SEVERE, "Cannot access backing store", backingStoreException);
        }
    }

    public void deleteAll() {
        try {
            PortfolioDAO.getPortfoliosRootPref().removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            fLogger.log(Level.SEVERE, "Cannot access backing store.", backingStoreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportXML(File file) {
        try (OutputStream outputStream = null;){
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            PortfolioDAO.getPortfoliosRootPref().exportSubtree(outputStream);
        }
        catch (IOException iOException) {
            fLogger.severe("Cannot save to file " + file);
        }
        catch (BackingStoreException backingStoreException) {
            fLogger.log(Level.SEVERE, "Cannot access backing store.", backingStoreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importXML(File file) {
        try (InputStream inputStream = null;){
            inputStream = new BufferedInputStream(new FileInputStream(file));
            PortfolioDAO.getPortfoliosRootPref();
            Preferences.importPreferences(inputStream);
        }
        catch (IOException iOException) {
            fLogger.severe("Cannot read file " + file);
        }
        catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
            fLogger.log(Level.SEVERE, "Format of Preferences file is invalid.", invalidPreferencesFormatException);
        }
    }

    private static Preferences getPortfoliosRootPref() {
        return Preferences.systemNodeForPackage(PortfolioDAO.class);
    }

    private Preferences getExistingPortfolioPref(String string) {
        if (this.isStored(string)) {
            return PortfolioDAO.getPortfoliosRootPref().node(string);
        }
        throw new IllegalArgumentException("Unknown Portfolio Name:" + string);
    }

    private boolean isStored(String string) {
        boolean bl = false;
        try {
            bl = PortfolioDAO.getPortfoliosRootPref().nodeExists(string);
        }
        catch (BackingStoreException backingStoreException) {
            fLogger.severe("Cannot access backing store for Portfolio Name: " + string + " Exception: " + backingStoreException);
        }
        return bl;
    }

    private Set<Stock> getStocks(Preferences preferences) {
        HashSet<Stock> hashSet = new HashSet<Stock>();
        String string = preferences.get(STOCKS_KEY, "");
        String string2 = "[],";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (!this.rawStockHasContent(string3)) continue;
            Stock stock = this.getStock(string3);
            hashSet.add(stock);
        }
        return new TreeSet<Stock>(hashSet);
    }

    private boolean rawStockHasContent(String string) {
        return string != null && string.trim().length() > 0 && !string.equalsIgnoreCase("null");
    }

    private Stock getStock(String string) {
        Stock stock = null;
        String string2 = ":";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            Exchange exchange = Exchange.valueFrom(stringTokenizer.nextToken());
            Integer n = Integer.valueOf(stringTokenizer.nextToken());
            BigDecimal bigDecimal = new BigDecimal(stringTokenizer.nextToken());
            stock = new Stock(string4, string3, exchange, n, bigDecimal);
        }
        catch (NoSuchElementException noSuchElementException) {
            fLogger.severe("Cannot parse into Stock object: \"" + string + "\"");
        }
        return stock;
    }

    private static void main(String ... stringArray) {
        Exchange exchange = Exchange.valueFrom("NYSE Stock Exchanges");
        Exchange exchange2 = Exchange.valueFrom("Nasdaq Stock Exchange");
        Exchange exchange3 = Exchange.valueFrom("Toronto Stock Exchange");
        Stock stock = new Stock("Big Blue", "IBM", exchange, new Integer(100), new BigDecimal("6.00"));
        Stock stock2 = new Stock("Cisco Systems", "CSCO", exchange2, new Integer(200), new BigDecimal("10.25"));
        Stock stock3 = new Stock("Canadian Tire", "CTR", exchange3, new Integer(100), new BigDecimal("5.00"));
        Stock stock4 = new Stock("Philip Morris", "MO", exchange, new Integer(200), new BigDecimal("3.25"));
        TreeSet<Stock> treeSet = new TreeSet<Stock>();
        treeSet.add(stock);
        treeSet.add(stock2);
        treeSet.add(stock3);
        treeSet.add(stock4);
        Portfolio portfolio = new Portfolio("Alaska", treeSet);
        PortfolioDAO portfolioDAO = new PortfolioDAO();
        portfolioDAO.saveAs(portfolio);
        Stock stock5 = new Stock("Pepsi", "PEP", exchange, new Integer(800), new BigDecimal("5.65"));
        treeSet.add(stock5);
        portfolioDAO.saveAs(new Portfolio("Le Havre", treeSet));
        portfolioDAO.saveAsDefault(portfolio);
    }
}

