/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.portfolio;

import hirondelle.stocks.quotes.Quote;
import hirondelle.stocks.quotes.QuotesDAO;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Consts;
import hirondelle.stocks.util.DataAccessException;
import hirondelle.stocks.util.EqualsUtil;
import hirondelle.stocks.util.HashCodeUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class Portfolio {
    private String fName;
    private Set<Stock> fStocks;
    private static final String UNTITLED = "";

    public Portfolio(String string, Set<Stock> set) {
        this.setName(string);
        this.setStocks(set);
    }

    public static Portfolio getUntitledPortfolio() {
        return new Portfolio();
    }

    public boolean isUntitled() {
        return this.getName().equals(UNTITLED);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        Args.checkForContent(string);
        this.fName = string;
    }

    public Set<Stock> getStocks() {
        return this.fStocks;
    }

    public void setStocks(Set<Stock> set) {
        Args.checkForNull(set);
        this.fStocks = Collections.unmodifiableSet(set);
    }

    public List<Quote> getQuotes() throws DataAccessException {
        QuotesDAO quotesDAO = new QuotesDAO(QuotesDAO.UseMonitor.TRUE, this.fStocks);
        return quotesDAO.getQuotes();
    }

    public BigDecimal getBookValue(Collection<Quote> collection) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (Quote quote : collection) {
            Stock stock = quote.getStock();
            if (!this.fStocks.contains(stock)) {
                throw new IllegalArgumentException("Unknown stock: " + stock);
            }
            bigDecimal = bigDecimal.add(stock.getBookValue());
        }
        return bigDecimal.setScale(2, 6);
    }

    public BigDecimal getCurrentValue(Collection<Quote> collection) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (Quote quote : collection) {
            Stock stock = quote.getStock();
            if (!this.fStocks.contains(stock)) {
                throw new IllegalArgumentException("Unknown stock: " + stock);
            }
            bigDecimal = bigDecimal.add(quote.getCurrentValue());
        }
        return bigDecimal.setScale(2, 6);
    }

    public BigDecimal getProfit(Collection<Quote> collection) {
        return this.getCurrentValue(collection).subtract(this.getBookValue(collection));
    }

    public BigDecimal getPercentageProfit(Collection<Quote> collection) {
        BigDecimal bigDecimal = Consts.ZERO_MONEY;
        BigDecimal bigDecimal2 = this.getBookValue(collection);
        if (bigDecimal2.compareTo(Consts.ZERO_MONEY) != 0) {
            BigDecimal bigDecimal3 = this.getProfit(collection);
            bigDecimal = bigDecimal3.divide(bigDecimal2, 6);
        }
        return bigDecimal;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" {");
        stringBuilder.append(string);
        stringBuilder.append(" fName = ").append(this.fName).append(string);
        stringBuilder.append(" fStocks = ").append(this.fStocks).append(string);
        stringBuilder.append("}");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Portfolio)) {
            return false;
        }
        Portfolio portfolio = (Portfolio)object;
        return EqualsUtil.areEqual(this.fName, portfolio.fName) && EqualsUtil.areEqual(this.fStocks, portfolio.fStocks);
    }

    public int hashCode() {
        int n = 23;
        n = HashCodeUtil.hash(n, this.fName);
        n = HashCodeUtil.hash(n, this.fStocks);
        return n;
    }

    private Portfolio() {
        this.fName = UNTITLED;
        this.setStocks(new TreeSet<Stock>());
    }
}

