/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.portfolio;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.util.Args;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class EditSaver {
    private Action fSaveAction;
    private Action fSaveAsAction;
    private JFrame fFrame;

    public EditSaver(Action action, Action action2, JFrame jFrame) {
        Args.checkForNull(action);
        Args.checkForNull(action2);
        Args.checkForNull(jFrame);
        this.fSaveAction = action;
        this.fSaveAsAction = action2;
        this.fFrame = jFrame;
    }

    public void save(CurrentPortfolio currentPortfolio, ActionEvent actionEvent) {
        if (!currentPortfolio.getNeedsSave()) {
            return;
        }
        if (!this.userWantsToSaveEdits(currentPortfolio)) {
            return;
        }
        if (currentPortfolio.isUntitled()) {
            this.fSaveAsAction.actionPerformed(actionEvent);
        } else {
            this.fSaveAction.actionPerformed(actionEvent);
        }
    }

    private boolean userWantsToSaveEdits(CurrentPortfolio currentPortfolio) {
        StringBuilder stringBuilder = new StringBuilder("Do you want to save the edits for the \"");
        stringBuilder.append(currentPortfolio.getName());
        stringBuilder.append("\" portfolio?");
        int n = JOptionPane.showConfirmDialog(this.fFrame, stringBuilder.toString(), "Confirm Save Edits", 0);
        return n == 0;
    }
}

