/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.portfolio;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.StockEditor;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.StandardEditor;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class EditPortfolioAction
extends AbstractAction {
    private CurrentPortfolio fCurrentPortfolio;
    private Set<Stock> fWorkingCopy;
    private JList<Model> fStockSelector;
    private Model fModel;
    private JFrame fFrame;
    private static final Logger fLogger = Util.getLogger(EditPortfolioAction.class);

    public EditPortfolioAction(CurrentPortfolio currentPortfolio, JFrame jFrame) {
        super("Portfolio...", UiUtil.getEmptyIcon());
        Args.checkForNull(currentPortfolio);
        Args.checkForNull(jFrame);
        this.fCurrentPortfolio = currentPortfolio;
        this.fModel = new Model();
        this.fFrame = jFrame;
        this.putValue("ShortDescription", "Edit the stocks in this portfolio");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 2));
        this.putValue("LongDescription", "Add, change, delete operations on stocks in portfolio.");
        this.putValue("MnemonicKey", new Integer(80));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Edit the list of stocks in the current portfolio.");
        this.initWorkingCopy();
        this.showDialog();
    }

    private void initWorkingCopy() {
        this.fWorkingCopy = new TreeSet<Stock>(this.fCurrentPortfolio.getStocks());
        fLogger.fine("Working copy inited to: " + this.fWorkingCopy);
    }

    private void synchDisplayWithWorkingCopy() {
        this.fStockSelector.setSelectedIndex(0);
        this.fStockSelector.updateUI();
    }

    private void showDialog() {
        Editor editor = new Editor("Edit Portfolio", this.fFrame);
        editor.showDialog();
    }

    private JComponent getStockSelector() {
        this.fStockSelector = new JList(this.fModel);
        this.fStockSelector.setSelectionMode(0);
        this.fStockSelector.setToolTipText("Choose item, then change or delete using buttons");
        JScrollPane jScrollPane = new JScrollPane(this.fStockSelector);
        return jScrollPane;
    }

    private JComponent getCommandColumn() {
        JButton jButton = new JButton("Add...");
        jButton.setMnemonic(65);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditPortfolioAction.this.addStock();
            }
        });
        class ChangeAction
        extends EditAction {
            ChangeAction() {
                super("Change...", 67);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditPortfolioAction.this.changeSelectedStock();
            }
        }
        JButton jButton2 = new JButton(new ChangeAction());
        class DeleteAction
        extends EditAction {
            DeleteAction() {
                super("Delete", 68);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditPortfolioAction.this.deleteSelectedStock();
            }
        }
        JButton jButton3 = new JButton(new DeleteAction());
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(jButton);
        arrayList.add(jButton2);
        arrayList.add(jButton3);
        return UiUtil.getCommandColumn(arrayList);
    }

    private void addStock() {
        StockEditor stockEditor = new StockEditor(this.fFrame);
        Stock stock = stockEditor.addStock();
        fLogger.fine("Adding stock to working copy: " + stock);
        if (stock != null) {
            this.fWorkingCopy.add(stock);
            this.synchDisplayWithWorkingCopy();
        }
    }

    private void changeSelectedStock() {
        fLogger.fine("Changing stock...");
        Stock stock = this.getSelectedStock();
        StockEditor stockEditor = new StockEditor(this.fFrame);
        Stock stock2 = stockEditor.changeStock(stock);
        if (stock2 != null) {
            this.fWorkingCopy.remove(stock);
            this.fWorkingCopy.add(stock2);
            this.synchDisplayWithWorkingCopy();
        }
    }

    private void deleteSelectedStock() {
        Stock stock = this.getSelectedStock();
        this.fWorkingCopy.remove(stock);
        this.synchDisplayWithWorkingCopy();
    }

    private Stock getSelectedStock() {
        int n = this.fStockSelector.getSelectionModel().getLeadSelectionIndex();
        Set<Stock> set = this.fWorkingCopy;
        ArrayList<Stock> arrayList = new ArrayList<Stock>(set);
        return (Stock)arrayList.get(n);
    }

    private boolean isSelectionPresent() {
        return !this.fStockSelector.getSelectionModel().isSelectionEmpty();
    }

    private final class Model
    extends AbstractListModel {
        private Model() {
        }

        @Override
        public Object getElementAt(int n) {
            Set set = EditPortfolioAction.this.fWorkingCopy;
            ArrayList arrayList = new ArrayList(set);
            Stock stock = (Stock)arrayList.get(n);
            return stock.getName();
        }

        @Override
        public int getSize() {
            return EditPortfolioAction.this.fWorkingCopy.size();
        }
    }

    private final class Editor
    extends StandardEditor {
        Editor(String string, JFrame jFrame) {
            super(string, jFrame, StandardEditor.CloseAction.HIDE);
        }

        @Override
        protected JComponent getEditorUI() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(EditPortfolioAction.this.getStockSelector());
            jPanel.add(EditPortfolioAction.this.getCommandColumn());
            return jPanel;
        }

        @Override
        protected void okAction() {
            if (EditPortfolioAction.this.fWorkingCopy.equals(EditPortfolioAction.this.fCurrentPortfolio.getStocks())) {
                fLogger.fine("No detected change in underlying stocks.");
            } else {
                fLogger.fine("Detected change in underlying stocks.");
                EditPortfolioAction.this.fCurrentPortfolio.setStocks(EditPortfolioAction.this.fWorkingCopy);
                EditPortfolioAction.this.fCurrentPortfolio.setNeedsSave(true);
                EditPortfolioAction.this.fCurrentPortfolio.notifyObservers();
            }
            this.dispose();
        }
    }

    private abstract class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        EditAction(String string, int n) {
            super(string);
            this.putValue("MnemonicKey", new Integer(n));
            this.setEnabled(false);
            EditPortfolioAction.this.fStockSelector.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            fLogger.fine("Firing EditAction.valueChanged");
            this.setEnabled(EditPortfolioAction.this.isSelectionPresent());
        }
    }
}

