/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.portfolio;

import hirondelle.stocks.portfolio.Portfolio;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.util.Args;
import java.util.Observable;
import java.util.Set;

public final class CurrentPortfolio
extends Observable {
    private Portfolio fPortfolio;
    private boolean fNeedsSave;

    public CurrentPortfolio(Portfolio portfolio, NeedsSave needsSave) {
        Args.checkForNull(portfolio);
        this.fPortfolio = portfolio;
        this.fNeedsSave = needsSave.getValue();
        this.setChanged();
    }

    public void clear() {
        this.setPortfolio(Portfolio.getUntitledPortfolio());
        this.setNeedsSave(false);
    }

    public boolean isUntitled() {
        return this.fPortfolio.isUntitled();
    }

    public Portfolio getPortfolio() {
        return this.fPortfolio;
    }

    public void setPortfolio(Portfolio portfolio) {
        Args.checkForNull(portfolio);
        this.fPortfolio = portfolio;
        this.setChanged();
    }

    public String getName() {
        return this.fPortfolio.getName();
    }

    public void setName(String string) {
        this.fPortfolio.setName(string);
        this.setChanged();
    }

    public Set<Stock> getStocks() {
        return this.fPortfolio.getStocks();
    }

    public void setStocks(Set<Stock> set) {
        this.fPortfolio.setStocks(set);
        this.setChanged();
    }

    public boolean getNeedsSave() {
        return this.fNeedsSave;
    }

    public void setNeedsSave(boolean bl) {
        this.fNeedsSave = bl;
        this.setChanged();
    }

    public static enum NeedsSave {
        TRUE(true),
        FALSE(false);

        private final boolean fToggle;

        boolean getValue() {
            return this.fToggle;
        }

        private NeedsSave(boolean bl) {
            this.fToggle = bl;
        }
    }
}

