/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.main;

import hirondelle.stocks.export.ExportAction;
import hirondelle.stocks.export.ImportAction;
import hirondelle.stocks.file.FileCloseAction;
import hirondelle.stocks.file.FileDeleteAction;
import hirondelle.stocks.file.FileExitAction;
import hirondelle.stocks.file.FileNewAction;
import hirondelle.stocks.file.FileOpenAction;
import hirondelle.stocks.file.FileSaveAction;
import hirondelle.stocks.file.FileSaveAsAction;
import hirondelle.stocks.help.AboutAction;
import hirondelle.stocks.help.HelpAction;
import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.EditPortfolioAction;
import hirondelle.stocks.portfolio.EditSaver;
import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.preferences.EditUserPreferencesAction;
import hirondelle.stocks.preferences.GeneralLookPreferencesEditor;
import hirondelle.stocks.preferences.LoggingPreferencesEditor;
import hirondelle.stocks.preferences.OptionPaneExceptionHandler;
import hirondelle.stocks.preferences.PreferencesEditor;
import hirondelle.stocks.preferences.QuoteTablePreferencesEditor;
import hirondelle.stocks.quotes.FetchQuotesAction;
import hirondelle.stocks.quotes.SummaryView;
import hirondelle.stocks.table.QuoteFilterFactory;
import hirondelle.stocks.table.QuoteTable;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.Theme;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

final class StocksMonitorMainWindow
implements Observer {
    private JFrame fFrame;
    private CurrentPortfolio fCurrentPortfolio;
    private GeneralLookPreferencesEditor fGeneralLookPrefs;
    private QuoteTable fQuoteTable;
    private QuoteTablePreferencesEditor fQuoteTablePrefsEditor;
    private QuoteFilterFactory fQuoteFilterFactory;
    private SummaryView fSummaryView;
    private Action fExitAction;
    private Action fEditUserPreferencesAction;
    private FetchQuotesAction fFetchQuotesAction;
    private Action fFileNewAction;
    private Action fFileOpenAction;
    private Action fFileCloseAction;
    private Action fFileSaveAction;
    private Action fFileSaveAsAction;
    private Action fFileDeleteAction;
    private JToolBar fToolbar;
    private static final Dimension MAIN_PANEL_SIZE = new Dimension(400, 300);
    private static final String ICON = "favicon.gif";
    private static final Logger fLogger = Util.getLogger(StocksMonitorMainWindow.class);

    public StocksMonitorMainWindow() {
        this.initCurrentPortfolio();
        this.initGuiPieces();
        this.initFrame();
        this.initActions();
        this.initMainGui();
        this.broadcastCurrentPortfolioUpdate();
        this.showMainWindow();
        OptionPaneExceptionHandler.attachToRootLogger();
    }

    @Override
    public void update(Observable observable, Object object) {
        fLogger.fine("Notify being broadcast...");
        if (observable == this.fCurrentPortfolio) {
            fLogger.fine("Notified by Current Portfolio...");
            this.synchTitleBarWithCurrentPortfolio();
        } else if (observable == this.fGeneralLookPrefs) {
            fLogger.fine("Notified by General Look...");
            this.synchGuiWithGeneralLookPrefs();
        }
    }

    private void initCurrentPortfolio() {
        fLogger.info("Initializing the current portfolio");
        PortfolioDAO portfolioDAO = new PortfolioDAO();
        this.fCurrentPortfolio = new CurrentPortfolio(portfolioDAO.fetchDefaultPortfolio(), CurrentPortfolio.NeedsSave.FALSE);
        this.fCurrentPortfolio.addObserver(this);
    }

    private void initGuiPieces() {
        fLogger.info("Initializing main pieces of the GUI.");
        this.fQuoteFilterFactory = new QuoteFilterFactory(this.fCurrentPortfolio);
        this.fSummaryView = new SummaryView(this.fCurrentPortfolio, this.fQuoteFilterFactory);
        this.fQuoteTablePrefsEditor = new QuoteTablePreferencesEditor();
        this.fQuoteTable = new QuoteTable(this.fQuoteTablePrefsEditor, this.fQuoteFilterFactory);
        this.fGeneralLookPrefs = new GeneralLookPreferencesEditor();
        this.fGeneralLookPrefs.addObserver(this);
    }

    private void initFrame() {
        this.fFrame = new JFrame();
        ImageIcon imageIcon = UiUtil.getImageIcon(ICON, this.getClass());
        this.fFrame.setIconImage(imageIcon.getImage());
    }

    private void initActions() {
        fLogger.info("Initializing Actions.");
        this.fFileDeleteAction = new FileDeleteAction(this.fCurrentPortfolio, this.fFrame);
        this.fFileSaveAction = new FileSaveAction(this.fCurrentPortfolio);
        this.fFileSaveAsAction = new FileSaveAsAction(this.fCurrentPortfolio, this.fFrame);
        EditSaver editSaver = new EditSaver(this.fFileSaveAction, this.fFileSaveAsAction, this.fFrame);
        this.fFileNewAction = new FileNewAction(this.fCurrentPortfolio, this.fFrame, editSaver);
        this.fFileOpenAction = new FileOpenAction(this.fCurrentPortfolio, this.fFrame, editSaver);
        this.fFileCloseAction = new FileCloseAction(this.fCurrentPortfolio, editSaver);
        ArrayList<PreferencesEditor> arrayList = new ArrayList<PreferencesEditor>();
        arrayList.add(this.fGeneralLookPrefs);
        arrayList.add(new LoggingPreferencesEditor());
        arrayList.add(this.fQuoteTablePrefsEditor);
        this.fEditUserPreferencesAction = new EditUserPreferencesAction(this.fFrame, arrayList);
        this.fExitAction = new FileExitAction(this.fCurrentPortfolio, editSaver);
        this.fFetchQuotesAction = new FetchQuotesAction(this.fCurrentPortfolio, this.fQuoteTablePrefsEditor, this.fQuoteTable, this.fSummaryView);
        this.fFetchQuotesAction.startTimer();
    }

    private void initMainGui() {
        fLogger.info("Initializing larges pieces of the GUI.");
        JSplitPane jSplitPane = new JSplitPane(1, this.fQuoteFilterFactory, this.getStocksTableAndSummary());
        jSplitPane.setOneTouchExpandable(true);
        this.fFrame.setJMenuBar(this.getMenuBar());
        this.fToolbar = this.getToolBar();
        this.fFrame.getContentPane().add((Component)this.fToolbar, "North");
        this.fFrame.getContentPane().add((Component)jSplitPane, "Center");
        this.fFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StocksMonitorMainWindow.this.fExitAction.actionPerformed(null);
            }
        });
    }

    private void broadcastCurrentPortfolioUpdate() {
        this.fCurrentPortfolio.notifyObservers();
    }

    private JMenuBar getMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.add(this.fFileNewAction);
        jMenu.add(this.fFileOpenAction);
        jMenu.add(this.fFileCloseAction);
        jMenu.addSeparator();
        jMenu.add(this.fFileSaveAction);
        jMenu.add(this.fFileSaveAsAction);
        jMenu.add(this.fFileDeleteAction);
        jMenu.addSeparator();
        jMenu.add(this.fEditUserPreferencesAction);
        jMenu.addSeparator();
        jMenu.add(new ImportAction(this.fFrame));
        jMenu.add(new ExportAction(this.fFrame));
        jMenu.addSeparator();
        jMenu.add(this.fExitAction);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        jMenu2.add(new EditPortfolioAction(this.fCurrentPortfolio, this.fFrame));
        jMenu2.add(this.fFetchQuotesAction);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic(72);
        jMenu3.add(new HelpAction(this.fFrame, "Contents", 67, null, HelpAction.View.CONTENTS));
        jMenu3.add(new HelpAction(this.fFrame, "Index", 73, null, HelpAction.View.INDEX));
        jMenu3.add(new HelpAction(this.fFrame, "Search...", 83, null, HelpAction.View.SEARCH));
        jMenu3.add(new JSeparator());
        jMenu3.add(new AboutAction(this.fFrame));
        jMenuBar.add(jMenu3);
        return jMenuBar;
    }

    private JToolBar getToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(true);
        jToolBar.add(this.fFileNewAction);
        jToolBar.add(this.fFileOpenAction);
        jToolBar.add(this.fFileSaveAction);
        jToolBar.add(this.fFileSaveAsAction);
        jToolBar.add(this.fFileDeleteAction);
        jToolBar.addSeparator();
        jToolBar.add(this.fFetchQuotesAction);
        return jToolBar;
    }

    private JComponent getStocksTableAndSummary() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.fQuoteTable);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.fSummaryView);
        jPanel.setPreferredSize(MAIN_PANEL_SIZE);
        return jPanel;
    }

    private void showMainWindow() {
        fLogger.info("Showing the main window.");
        if (!Theme.hasLargeFont(this.fGeneralLookPrefs.getTheme())) {
            this.synchGuiWithGeneralLookPrefs();
            UiUtil.centerAndShow(this.fFrame);
        } else {
            UiUtil.centerAndShow(this.fFrame);
            this.synchGuiWithGeneralLookPrefs();
        }
    }

    private void synchTitleBarWithCurrentPortfolio() {
        StringBuilder stringBuilder = new StringBuilder("StocksMonitor");
        stringBuilder.append(" ");
        stringBuilder.append("1.7.0");
        stringBuilder.append(" - Portfolio : ");
        if (this.fCurrentPortfolio.isUntitled()) {
            stringBuilder.append("(Untitled)");
        } else {
            stringBuilder.append(this.fCurrentPortfolio.getName());
        }
        if (this.fCurrentPortfolio.getNeedsSave()) {
            stringBuilder.append(" *");
        }
        this.fFrame.setTitle(stringBuilder.toString());
    }

    private void synchGuiWithGeneralLookPrefs() {
        if (this.fGeneralLookPrefs.hasShowToolBar()) {
            this.fToolbar.setVisible(true);
        } else {
            this.fQuoteFilterFactory.requestFocusInWindow();
            this.fToolbar.setVisible(false);
        }
        MetalTheme metalTheme = this.fGeneralLookPrefs.getTheme();
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            fLogger.severe("Cannot set new Theme for Java Look and Feel.");
        }
        SwingUtilities.updateComponentTreeUI(this.fFrame);
    }
}

