/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.main;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.net.URL;

final class SplashScreen
extends Frame {
    private final String fImageId;
    private MediaTracker fMediaTracker;
    private Image fImage;
    private static final ImageObserver NO_OBSERVER = null;
    private static final int IMAGE_ID = 0;

    SplashScreen(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Image Id does not have content.");
        }
        this.fImageId = string;
    }

    void splash() {
        this.initImageAndTracker();
        this.setSize(this.fImage.getWidth(NO_OBSERVER), this.fImage.getHeight(NO_OBSERVER));
        this.center();
        this.fMediaTracker.addImage(this.fImage, 0);
        try {
            this.fMediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Cannot track image load.");
        }
        SplashWindow splashWindow = new SplashWindow(this, this.fImage);
    }

    private void initImageAndTracker() {
        this.fMediaTracker = new MediaTracker(this);
        URL uRL = SplashScreen.class.getResource(this.fImageId);
        this.fImage = Toolkit.getDefaultToolkit().getImage(uRL);
    }

    private void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        this.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
    }

    private static void main(String ... stringArray) {
        SplashScreen splashScreen = new SplashScreen("StocksMonitor.gif");
        splashScreen.splash();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
        System.exit(0);
    }

    private final class SplashWindow
    extends Window {
        private Image fImage;

        SplashWindow(Frame frame, Image image) {
            super(frame);
            this.fImage = image;
            this.setSize(this.fImage.getWidth(NO_OBSERVER), this.fImage.getHeight(NO_OBSERVER));
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle rectangle = this.getBounds();
            this.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
            this.setVisible(true);
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.fImage != null) {
                graphics.drawImage(this.fImage, 0, 0, this);
            }
        }
    }
}

