/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.main;

import hirondelle.stocks.main.SplashScreen;
import hirondelle.stocks.main.StocksMonitorMainWindow;
import hirondelle.stocks.util.Util;
import java.awt.EventQueue;
import java.util.logging.Logger;

public final class Launcher {
    private static SplashScreen fSplashScreen;
    private static final Logger fLogger;
    private static final String SPLASH_IMAGE = "StocksMonitor.gif";

    public static void main(String ... stringArray) {
        Launcher.logBasicSystemInfo();
        Launcher.showSplashScreen();
        Launcher.showMainWindow();
        EventQueue.invokeLater(new SplashScreenCloser());
        fLogger.info("Launch thread now exiting...");
    }

    private static void showSplashScreen() {
        fLogger.info("Showing the splash screen.");
        fSplashScreen = new SplashScreen(SPLASH_IMAGE);
        fSplashScreen.splash();
    }

    private static void showMainWindow() {
        fLogger.info("Showing the main window.");
        StocksMonitorMainWindow stocksMonitorMainWindow = new StocksMonitorMainWindow();
    }

    private static void logBasicSystemInfo() {
        fLogger.info("Launching the application...");
        fLogger.config("Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        fLogger.config("JRE: " + System.getProperty("java.version"));
        fLogger.info("Java Launched From: " + System.getProperty("java.home"));
        fLogger.config("Class Path: " + System.getProperty("java.class.path"));
        fLogger.config("Library Path: " + System.getProperty("java.library.path"));
        fLogger.config("Application Name: StocksMonitor/1.7.0");
        fLogger.config("User Home Directory: " + System.getProperty("user.home"));
        fLogger.config("User Working Directory: " + System.getProperty("user.dir"));
        fLogger.info("Test INFO logging.");
        fLogger.fine("Test FINE logging.");
        fLogger.finest("Test FINEST logging.");
    }

    static {
        fLogger = Util.getLogger(Launcher.class);
    }

    private static final class SplashScreenCloser
    implements Runnable {
        private SplashScreenCloser() {
        }

        @Override
        public void run() {
            fLogger.fine("Closing the splash screen.'");
            fSplashScreen.dispose();
        }
    }
}

