/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.help;

import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.logging.Logger;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;

public final class HelpAction
extends AbstractAction {
    private JFrame fFrame;
    private View fView;
    private static final String PATH_TO_JAVA_HELP = "hirondelle/stocks/help/JavaHelp/HelpSet.hs";
    private ClassLoader DEFAULT_CLASS_LOADER = null;
    private static final Logger fLogger = Util.getLogger(HelpAction.class);
    private HelpBroker fHelpBroker;
    private CSH.DisplayHelpFromSource fDisplayHelp;

    public HelpAction(JFrame jFrame, String string, int n, Icon icon, View view) {
        super(string, icon);
        Args.checkForNull(jFrame);
        Args.checkForNull(string);
        Args.checkForNull((Object)view);
        this.fFrame = jFrame;
        this.fView = view;
        this.putValue("ShortDescription", "StocksMonitor Help");
        this.putValue("LongDescription", "Displays JavaHelp for StocksMonitor.");
        this.putValue("MnemonicKey", new Integer(n));
        this.initHelpSystem();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Showing help system.");
        this.fHelpBroker.setCurrentView(this.fView.toString());
        this.fDisplayHelp.actionPerformed(actionEvent);
    }

    private void initHelpSystem() {
        if (this.fHelpBroker != null && this.fDisplayHelp != null) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = HelpSet.findHelpSet(classLoader, PATH_TO_JAVA_HELP);
        assert (uRL != null) : "Cannot find help system.";
        try {
            HelpSet helpSet = new HelpSet(this.DEFAULT_CLASS_LOADER, uRL);
            this.fHelpBroker = helpSet.createHelpBroker();
            this.fHelpBroker.enableHelpKey(this.fFrame.getRootPane(), "overview", helpSet);
            this.fDisplayHelp = new CSH.DisplayHelpFromSource(this.fHelpBroker);
        }
        catch (HelpSetException helpSetException) {
            fLogger.severe("Cannot create help system with: " + uRL);
        }
        assert (this.fHelpBroker != null) : "HelpBroker is null.";
    }

    public static enum View {
        SEARCH("Search"),
        CONTENTS("TOC"),
        INDEX("Index");

        private String fName;

        public String toString() {
            return this.fName;
        }

        private View(String string2) {
            this.fName = string2;
        }
    }
}

