/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.help;

import hirondelle.stocks.preferences.LoggingPreferencesEditor;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Consts;
import hirondelle.stocks.util.FileUtil;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public final class AboutAction
extends AbstractAction {
    private JFrame fFrame;
    private JLabel fObjectHeapSize;
    private Timer fTimer;
    private ActionListener fHeapSizeUpdater;
    private static final int UPDATE_FREQ = 2000;
    private static final long SLEEP_INTERVAL = 100L;
    private static final String ABOUT_TEXT_FILE = "About.txt";
    private static final Dimension ABOUT_TEXT_SIZE = new Dimension(100, 250);
    private static final Logger fLogger = Util.getLogger(AboutAction.class);

    public AboutAction(JFrame jFrame) {
        super("About StocksMonitor");
        Args.checkForNull(jFrame);
        this.fFrame = jFrame;
        this.putValue("ShortDescription", "About this application");
        this.putValue("LongDescription", "Displays details regarding the StocksMonitor application.");
        this.putValue("MnemonicKey", new Integer(65));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Showing the about box.");
        this.showAboutBox();
    }

    private void showAboutBox() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("About", this.getAboutPanel());
        jTabbedPane.setMnemonicAt(0, 65);
        jTabbedPane.addTab("System Info", this.getSystemInfoPanel());
        jTabbedPane.setMnemonicAt(1, 83);
        this.startHeapSizeTimer();
        ImageIcon imageIcon = UiUtil.getImageIcon("xray-small.jpg", this.getClass());
        String string = UiUtil.getDialogTitle("About");
        JOptionPane.showMessageDialog(this.fFrame, jTabbedPane, string, 0, imageIcon);
        this.stopHeapSizeTimer();
    }

    private JComponent getAboutPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String string = "StocksMonitor 1.7.0";
        String string2 = string + Consts.NEW_LINE + this.getAboutFileContents();
        JTextArea jTextArea = UiUtil.getStandardTextAreaHardNewLines(string2);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(ABOUT_TEXT_SIZE);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private String getAboutFileContents() {
        return FileUtil.asString(ABOUT_TEXT_FILE, this.getClass());
    }

    private JComponent getSystemInfoPanel() {
        JPanel jPanel = this.getStandardPanel();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.addSysProperty(hashMap, "Java Version", "java.version");
        this.addSysProperty(hashMap, "Java VM", "java.vm.info");
        this.addSysProperty(hashMap, "Java Home", "java.home");
        this.addSysProperty(hashMap, "Java Vendor", "java.vendor");
        this.addSysProperty(hashMap, "User Current Directory", "user.dir");
        this.addSysProperty(hashMap, "User Home Directory", "user.home");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getProperty("os.arch"));
        stringBuilder.append(" ");
        stringBuilder.append(this.getProperty("os.name"));
        stringBuilder.append(" ");
        stringBuilder.append(this.getProperty("os.version"));
        hashMap.put("Operating System", stringBuilder.toString());
        LoggingPreferencesEditor loggingPreferencesEditor = new LoggingPreferencesEditor();
        hashMap.put("Logging Config File", loggingPreferencesEditor.getLogConfigFile().toString());
        UiUtil.addSimpleDisplayFields(jPanel, new TreeMap<String, String>(hashMap));
        this.fObjectHeapSize = UiUtil.addSimpleDisplayField(jPanel, "Object Heap Size", this.getHeapSize(), UiUtil.getConstraints(8, 0), true);
        this.fObjectHeapSize.setToolTipText("Total memory consumption is much larger");
        this.addGarbageCollectionButton(jPanel);
        return jPanel;
    }

    private void addGarbageCollectionButton(JPanel jPanel) {
        JButton jButton = new JButton("Collect Garbage");
        jButton.setToolTipText("Request garbage collection by JVM");
        jButton.setMnemonic(67);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutAction.putOutTheGarbage();
                AboutAction.this.updateHeapSizeDisplay();
            }
        });
        GridBagConstraints gridBagConstraints = UiUtil.getConstraints(9, 1);
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    private JPanel getStandardPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(UiUtil.getStandardBorder());
        return jPanel;
    }

    private void updateHeapSizeDisplay() {
        fLogger.fine("Updating heap size...");
        this.fObjectHeapSize.setText(this.getHeapSize());
    }

    private String getHeapSize() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        Long l3 = new Long((l - l2) / 1024L);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UiUtil.getLocalizedInteger(l3));
        stringBuilder.append(" KB");
        return stringBuilder.toString();
    }

    private void startHeapSizeTimer() {
        this.fHeapSizeUpdater = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutAction.this.updateHeapSizeDisplay();
            }
        };
        this.fTimer = new Timer(2000, this.fHeapSizeUpdater);
        this.fTimer.start();
        fLogger.fine("Starting timer...");
    }

    private void stopHeapSizeTimer() {
        fLogger.fine("Stopping timer...");
        this.fTimer.stop();
        this.fTimer.removeActionListener(this.fHeapSizeUpdater);
        this.fHeapSizeUpdater = null;
        this.fTimer = null;
    }

    private static void putOutTheGarbage() {
        AboutAction.collectGarbage();
        AboutAction.collectGarbage();
    }

    private static void collectGarbage() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void addSysProperty(Map<String, String> map, String string, String string2) {
        map.put(string, this.getProperty(string2));
    }

    private String getProperty(String string) {
        return System.getProperty(string);
    }
}

