/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.file;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class FileSaveAsAction
extends AbstractAction {
    private CurrentPortfolio fCurrentPortfolio;
    private PortfolioDAO fPortfolioDAO;
    private JFrame fFrame;
    private static final Logger fLogger = Util.getLogger(FileSaveAsAction.class);

    public FileSaveAsAction(CurrentPortfolio currentPortfolio, JFrame jFrame) {
        super("Save As...", UiUtil.getImageIcon("/toolbarButtonGraphics/general/SaveAs"));
        Args.checkForNull(currentPortfolio);
        Args.checkForNull(jFrame);
        this.fCurrentPortfolio = currentPortfolio;
        this.fFrame = jFrame;
        this.putValue("ShortDescription", "Save the current portfolio under a new name");
        this.putValue("LongDescription", "Save the current portfolio under a new given name");
        this.putValue("MnemonicKey", new Integer(65));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Saving the current portfolio under a new name.");
        this.fPortfolioDAO = new PortfolioDAO();
        this.showDialog();
    }

    private void showDialog() {
        String string = "";
        while (this.isInvalid(string)) {
            string = this.askForNewName();
            if (string == null) {
                return;
            }
            if (!this.isInvalid(string)) continue;
            String string2 = UiUtil.getDialogTitle("Invalid Input");
            String string3 = "New name must have content, and must not duplicate a known Portfolio name.";
            JOptionPane.showMessageDialog(this.fFrame, string3, string2, 1);
        }
        this.savePortfolio(string);
    }

    private String askForNewName() {
        String string = UiUtil.getDialogTitle("Save As");
        return JOptionPane.showInputDialog(this.fFrame, "File Name:", string, 3);
    }

    private boolean isInvalid(String string) {
        return !this.fPortfolioDAO.isValidCandidateName(string);
    }

    private void savePortfolio(String string) {
        this.fCurrentPortfolio.setName(string);
        this.fCurrentPortfolio.setNeedsSave(false);
        this.fPortfolioDAO.saveAs(this.fCurrentPortfolio.getPortfolio());
        this.fCurrentPortfolio.notifyObservers();
    }
}

