/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.file;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public final class FileSaveAction
extends AbstractAction
implements Observer {
    private CurrentPortfolio fCurrentPortfolio;
    private static final Logger fLogger = Util.getLogger(FileSaveAction.class);

    public FileSaveAction(CurrentPortfolio currentPortfolio) {
        super("Save", UiUtil.getImageIcon("/toolbarButtonGraphics/general/Save"));
        this.fCurrentPortfolio = currentPortfolio;
        this.fCurrentPortfolio.addObserver(this);
        this.putValue("ShortDescription", "Save edits to the current portfolio");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        this.putValue("LongDescription", "Save edits to the current portfolio");
        this.putValue("MnemonicKey", new Integer(83));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Saving edits to the current portfolio.");
        PortfolioDAO portfolioDAO = new PortfolioDAO();
        portfolioDAO.save(this.fCurrentPortfolio.getPortfolio());
        this.fCurrentPortfolio.setNeedsSave(false);
        this.fCurrentPortfolio.notifyObservers();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(this.fCurrentPortfolio.getNeedsSave() && !this.fCurrentPortfolio.isUntitled());
    }
}

