/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.file;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.EditSaver;
import hirondelle.stocks.portfolio.Portfolio;
import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public final class FileOpenAction
extends AbstractAction {
    private CurrentPortfolio fCurrentPortfolio;
    private PortfolioDAO fPortfolioDAO;
    private JFrame fFrame;
    private EditSaver fEditSaver;
    private static final Logger fLogger = Util.getLogger(FileOpenAction.class);

    public FileOpenAction(CurrentPortfolio currentPortfolio, JFrame jFrame, EditSaver editSaver) {
        super("Open", UiUtil.getImageIcon("/toolbarButtonGraphics/general/Open"));
        Args.checkForNull(currentPortfolio);
        Args.checkForNull(jFrame);
        Args.checkForNull(editSaver);
        this.fCurrentPortfolio = currentPortfolio;
        this.fFrame = jFrame;
        this.fEditSaver = editSaver;
        this.putValue("ShortDescription", "Open an existing portfolio");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.putValue("LongDescription", "Open an existing portfolio with a given name");
        this.putValue("MnemonicKey", new Integer(79));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Open an existing portfolio.");
        this.fPortfolioDAO = new PortfolioDAO();
        this.fEditSaver.save(this.fCurrentPortfolio, actionEvent);
        this.showDialog();
    }

    private void showDialog() {
        String string = this.askForSelectedPortfolio();
        if (string != null) {
            this.openPortfolio(string);
        }
    }

    private String askForSelectedPortfolio() {
        Object[] objectArray = this.fPortfolioDAO.fetchAllPortfolioNames().toArray();
        String string = UiUtil.getDialogTitle("Open Portfolio");
        Object object = JOptionPane.showInputDialog(this.fFrame, "Please select a Portfolio:", string, 3, null, objectArray, null);
        return object == null ? null : object.toString();
    }

    private void openPortfolio(String string) {
        Portfolio portfolio = this.fPortfolioDAO.fetch(string);
        this.fCurrentPortfolio.setPortfolio(portfolio);
        this.fCurrentPortfolio.setNeedsSave(false);
        this.fCurrentPortfolio.notifyObservers();
    }
}

