/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.file;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.EditSaver;
import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.quotes.Stock;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public final class FileNewAction
extends AbstractAction {
    private CurrentPortfolio fCurrentPortfolio;
    private JFrame fFrame;
    private PortfolioDAO fPortfolioDAO;
    private EditSaver fEditSaver;
    private static final Logger fLogger = Util.getLogger(FileNewAction.class);

    public FileNewAction(CurrentPortfolio currentPortfolio, JFrame jFrame, EditSaver editSaver) {
        super("New", UiUtil.getImageIcon("/toolbarButtonGraphics/general/New"));
        Args.checkForNull(currentPortfolio);
        Args.checkForNull(jFrame);
        Args.checkForNull(editSaver);
        this.fCurrentPortfolio = currentPortfolio;
        this.fFrame = jFrame;
        this.fEditSaver = editSaver;
        this.putValue("ShortDescription", "Create a new portfolio");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        this.putValue("LongDescription", "Create a new portfolio with given name and an empty set of stocks");
        this.putValue("MnemonicKey", new Integer(78));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Start a new portfolio, with a unique name.");
        this.fPortfolioDAO = new PortfolioDAO();
        this.fEditSaver.save(this.fCurrentPortfolio, actionEvent);
        this.showDialog();
    }

    private void showDialog() {
        String string = "";
        while (this.isInvalid(string)) {
            string = this.askForNewName();
            if (string == null) {
                return;
            }
            if (!this.isInvalid(string)) continue;
            String string2 = "New name must have content, and must not duplicate a known Portfolio name.";
            JOptionPane.showMessageDialog(this.fFrame, string2, "Invalid Input", 1);
        }
        this.initNewPortfolio(string);
    }

    private String askForNewName() {
        String string = UiUtil.getDialogTitle("New File");
        return JOptionPane.showInputDialog(this.fFrame, "File Name:", string, 3);
    }

    private boolean isInvalid(String string) {
        return !this.fPortfolioDAO.isValidCandidateName(string);
    }

    private void initNewPortfolio(String string) {
        this.fCurrentPortfolio.setStocks(new TreeSet<Stock>());
        this.fCurrentPortfolio.setName(string);
        this.fCurrentPortfolio.setNeedsSave(false);
        this.fPortfolioDAO.saveAs(this.fCurrentPortfolio.getPortfolio());
        this.fCurrentPortfolio.notifyObservers();
    }
}

