/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.file;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.EditSaver;
import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public final class FileExitAction
extends AbstractAction {
    private CurrentPortfolio fCurrentPortfolio;
    private EditSaver fEditSaver;
    private static final Logger fLogger = Util.getLogger(FileExitAction.class);

    public FileExitAction(CurrentPortfolio currentPortfolio, EditSaver editSaver) {
        super("Exit", UiUtil.getEmptyIcon());
        Args.checkForNull(currentPortfolio);
        Args.checkForNull(editSaver);
        this.fEditSaver = editSaver;
        this.fCurrentPortfolio = currentPortfolio;
        this.putValue("ShortDescription", "Close the application");
        this.putValue("MnemonicKey", new Integer(88));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Exiting the application.");
        this.fEditSaver.save(this.fCurrentPortfolio, actionEvent);
        PortfolioDAO portfolioDAO = new PortfolioDAO();
        portfolioDAO.saveAsDefault(this.fCurrentPortfolio.getPortfolio());
        System.exit(0);
    }
}

