/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.file;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.Portfolio;
import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class FileDeleteAction
extends AbstractAction
implements Observer {
    private CurrentPortfolio fCurrentPortfolio;
    private JFrame fFrame;
    private static final Logger fLogger = Util.getLogger(FileDeleteAction.class);

    public FileDeleteAction(CurrentPortfolio currentPortfolio, JFrame jFrame) {
        super("Delete", UiUtil.getImageIcon("/toolbarButtonGraphics/general/Delete"));
        Args.checkForNull(jFrame);
        this.fCurrentPortfolio = currentPortfolio;
        this.fCurrentPortfolio.addObserver(this);
        this.fFrame = jFrame;
        this.putValue("ShortDescription", "Delete the current portfolio");
        this.putValue("LongDescription", "Delete the current portfolio,both  from view and storage.");
        this.putValue("MnemonicKey", new Integer(68));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Deleting the current portfolio from storage.");
        if (this.isConfirmed()) {
            this.deleteCurrentPortfolio();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(!this.fCurrentPortfolio.isUntitled());
    }

    private boolean isConfirmed() {
        String string = UiUtil.getDialogTitle("Confirm Delete");
        String string2 = "Are you sure you want to delete the Portfolio named '" + this.fCurrentPortfolio.getName() + "' ?";
        JOptionPane jOptionPane = new JOptionPane(string2, 2, 0);
        JDialog jDialog = jOptionPane.createDialog(this.fFrame, string);
        UiUtil.noDefaultButton(jDialog.getRootPane());
        jDialog.setVisible(true);
        return this.hasSelectedYes(jOptionPane);
    }

    private boolean hasSelectedYes(JOptionPane jOptionPane) {
        Integer n;
        boolean bl = false;
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (n = (Integer)object) == 0) {
            bl = true;
        }
        fLogger.fine("Selected Yes?: " + bl);
        return bl;
    }

    private void deleteCurrentPortfolio() {
        PortfolioDAO portfolioDAO = new PortfolioDAO();
        portfolioDAO.delete(this.fCurrentPortfolio.getPortfolio());
        this.fCurrentPortfolio.setPortfolio(Portfolio.getUntitledPortfolio());
        this.fCurrentPortfolio.notifyObservers();
    }
}

