/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.file;

import hirondelle.stocks.portfolio.CurrentPortfolio;
import hirondelle.stocks.portfolio.EditSaver;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public final class FileCloseAction
extends AbstractAction
implements Observer {
    private CurrentPortfolio fCurrentPortfolio;
    private EditSaver fEditSaver;
    private static final Logger fLogger = Util.getLogger(FileCloseAction.class);

    public FileCloseAction(CurrentPortfolio currentPortfolio, EditSaver editSaver) {
        super("Close", UiUtil.getEmptyIcon());
        Args.checkForNull(editSaver);
        this.fCurrentPortfolio = currentPortfolio;
        this.fCurrentPortfolio.addObserver(this);
        this.fEditSaver = editSaver;
        this.putValue("ShortDescription", "Close the current portfolio");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 2));
        this.putValue("LongDescription", "Close the current portfolio and display an empty set of stocks");
        this.putValue("MnemonicKey", new Integer(67));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Closing the current portfolio, and starting empty.");
        this.fEditSaver.save(this.fCurrentPortfolio, actionEvent);
        this.fCurrentPortfolio.clear();
        this.fCurrentPortfolio.setNeedsSave(false);
        this.fCurrentPortfolio.notifyObservers();
    }

    @Override
    public void update(Observable observable, Object object) {
        boolean bl = this.fCurrentPortfolio.isUntitled() && !this.fCurrentPortfolio.getNeedsSave();
        this.setEnabled(!bl);
    }
}

