/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.export;

import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class ImportAction
extends AbstractAction {
    private JFrame fFrame;
    private static File fDirOfInterest;
    private static final String fINVALID_IMPORT_FILE = "Invalid Import File";
    private static final Object[] fNO_READ_MESSAGE;
    private static final Object[] fNOT_EXIST_MESSAGE;
    private static final Logger fLogger;

    public ImportAction(JFrame jFrame) {
        super("Import...", UiUtil.getEmptyIcon());
        Args.checkForNull(jFrame);
        this.fFrame = jFrame;
        this.putValue("ShortDescription", "Import the result of a previous Export operation.");
        this.putValue("LongDescription", "Replace all Portfolios with those defined in a text file.");
        this.putValue("MnemonicKey", new Integer(73));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Importing portfolios from a text file.");
        JFileChooser jFileChooser = new JFileChooser(fDirOfInterest);
        jFileChooser.setDialogTitle("Import-Replace All Portfolios");
        jFileChooser.setApproveButtonToolTipText("Replace all Portfolios");
        int n = jFileChooser.showDialog(this.fFrame, "Import-And-Replace");
        if (n != 0) {
            fLogger.fine("No file selection made");
            return;
        }
        File file = jFileChooser.getSelectedFile();
        fDirOfInterest = file.getParentFile();
        if (!file.exists()) {
            fLogger.fine("Selected file does not exist " + file);
            this.showErrorMessage(fNOT_EXIST_MESSAGE);
            return;
        }
        if (file.exists() && !file.canRead()) {
            fLogger.fine("File does not have read access: " + file);
            this.showErrorMessage(fNO_READ_MESSAGE);
            return;
        }
        fLogger.fine("Attempting to import file");
        PortfolioDAO portfolioDAO = new PortfolioDAO();
        portfolioDAO.importXML(file);
    }

    private void showErrorMessage(Object[] objectArray) {
        JOptionPane.showMessageDialog(this.fFrame, objectArray, UiUtil.getDialogTitle(fINVALID_IMPORT_FILE), 0);
    }

    static {
        fNO_READ_MESSAGE = new Object[]{"File cannot be read.", "A readable file must be selected for an Import.", "Please select a different file."};
        fNOT_EXIST_MESSAGE = new Object[]{"File does not currently exist.", "An existing file must be selected for an Import.", "Please select a different file."};
        fLogger = Util.getLogger(ImportAction.class);
    }
}

