/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.stocks.export;

import hirondelle.stocks.portfolio.PortfolioDAO;
import hirondelle.stocks.util.Args;
import hirondelle.stocks.util.Util;
import hirondelle.stocks.util.ui.UiUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class ExportAction
extends AbstractAction {
    private JFrame fFrame;
    private static File fDirOfInterest;
    private static final Object[] fNO_WRITE_MESSAGE;
    private static final Logger fLogger;

    public ExportAction(JFrame jFrame) {
        super("Export...", UiUtil.getEmptyIcon());
        Args.checkForNull(jFrame);
        this.fFrame = jFrame;
        this.putValue("ShortDescription", "Save all stored Portfolios as a single text file");
        this.putValue("LongDescription", "Save all stored Portfolios as an XML file, suitable as input to the Import command.");
        this.putValue("MnemonicKey", new Integer(69));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        fLogger.info("Exporting Portfolios to a single text file.");
        JFileChooser jFileChooser = new JFileChooser(fDirOfInterest);
        jFileChooser.setDialogTitle("Export All Portfolios");
        jFileChooser.setApproveButtonToolTipText("Save all Portfolios to single text file");
        int n = jFileChooser.showDialog(this.fFrame, "Export");
        if (n != 0) {
            fLogger.fine("No file selection made");
            return;
        }
        File file = jFileChooser.getSelectedFile();
        fDirOfInterest = file.getParentFile();
        if (file.exists() && !file.canWrite()) {
            fLogger.fine("file does not have write access: " + file);
            JOptionPane.showMessageDialog(this.fFrame, fNO_WRITE_MESSAGE, UiUtil.getDialogTitle("Invalid Export File"), 0);
            return;
        }
        if (file.exists() && file.canWrite()) {
            fLogger.fine("File exists and may be overwritten: " + file);
            if (!this.isOverwriteConfirmed(file)) {
                return;
            }
        }
        fLogger.fine("Attempting to write to export file");
        PortfolioDAO portfolioDAO = new PortfolioDAO();
        portfolioDAO.exportXML(file);
    }

    private boolean isOverwriteConfirmed(File file) {
        String string = UiUtil.getDialogTitle("Confirm Overwrite");
        Object[] objectArray = new Object[]{"This file already exists.", "Do you wish to overwrite " + file.getName() + " ?"};
        int n = JOptionPane.showConfirmDialog(this.fFrame, objectArray, string, 0);
        return n == 0;
    }

    static {
        fNO_WRITE_MESSAGE = new Object[]{"Read-only file.", "The file you have selected is read-only, and cannot be changed.", "Please select a new file."};
        fLogger = Util.getLogger(ExportAction.class);
    }
}

